package ru.yandex.crypta.graph2.dao.yt.ops;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.DataSize;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.common.JavaOptions;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.reduce.Reducer;
import ru.yandex.inside.yt.kosher.operations.specs.ReduceSpec;
import ru.yandex.inside.yt.kosher.operations.specs.ReducerSpec;

public class JoinReduceOperation extends RichYtOperation {

    private static final Logger LOG = LoggerFactory.getLogger(ReduceOperation.class);

    private Yt yt;

    private ReducerSpec.Builder reducerSpecBuilder;
    private ReduceSpec.Builder reduceSpecBuilder;
    private ListF<String> joinBy;

    public JoinReduceOperation(Yt yt, ListF<YPath> inputTables, ListF<YPath> outputTables,
                               ListF<String> joinBy, Reducer reducer) {
        this.yt = yt;
        this.joinBy = joinBy;

        reducerSpecBuilder = ReducerSpec.builder()
                .setReducer(reducer)
                .setOutputTables(outputTables.size())
                .setJobTimeLimit(Option.of(DEFENSIVE_JOB_TIME_LIMIT.toMillis()).getOrNull())
                .setMemoryLimit(DataSize.fromBytes(DEFENSIVE_REDUCER_MEMORY_LIMIT.toBytes()))
                .setJavaOptions(JavaOptions.empty()
                        .withXmx(DataSize.fromBytes(DEFAULT_REDUCER_MEMORY_LIMIT.toBytes()))
                        .withOption(LOCAL_LIBRARY_PATH_OPTION) // allows operation to lookup uploaded .so files locally
                );

        reduceSpecBuilder = ReduceSpec.builder()
                .setInputTables(inputTables)
                .setOutputTables(outputTables)
                .setJoinBy(joinBy);

        String scriptName = CurrentScriptName.get();
        setScriptName(reduceSpecBuilder, scriptName);

    }

    public ReducerSpec.Builder getReducerSpecBuilder() {
        return reducerSpecBuilder;
    }

    public ReduceSpec.Builder getReduceSpecBuilder() {
        return reduceSpecBuilder;
    }

    @Override
    public Operation runAndGetOp(Option<GUID> transactionId) {
        ReducerSpec reducerSpec = reducerSpecBuilder.build();

        String description = reducerSpec.getMapperOrReducerTitle() + "[" + joinBy.mkString(",") + "]";
        LOG.info("Starting join reduce " + description);

        reduceSpecBuilder.setReducerSpec(reducerSpec);
        return yt.operations().reduceAndGetOp(transactionId.toOptional(), true, reduceSpecBuilder.build());
    }

}
