package ru.yandex.crypta.graph2.dao.yt.ops;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.MergeMode;
import ru.yandex.inside.yt.kosher.operations.specs.MergeSpec;

public class MergeOperation extends RichYtOperation {

    private static final Logger LOG = LoggerFactory.getLogger(MergeOperation.class);

    private Yt yt;

    private MergeSpec.Builder mergeSpecBuilder;
    private String description;

    public MergeOperation(Yt yt, ListF<YPath> in, YPath out) {
        this.yt = yt;

        mergeSpecBuilder = MergeSpec.builder()
                .setInputTables(in)
                .setOutputTable(out)
                .setMergeMode(MergeMode.UNORDERED)
                .setCombineChunks(true);

        String scriptName = CurrentScriptName.get();
        setScriptName(mergeSpecBuilder, scriptName);

        description = "Merging " + in + " to " + out;
    }

    @Override
    public Operation runAndGetOp(Option<GUID> transactionId) {
        LOG.info("Starting operation: " + description);
        return yt.operations().mergeAndGetOp(transactionId.toOptional(), true, mergeSpecBuilder.build());
    }

    public MergeSpec.Builder getMergeSpecBuilder() {
        return mergeSpecBuilder;
    }

    public MergeOperation withSchemaInferenceMode(String schemaInferenceMode) {
        mergeSpecBuilder.plusAdditionalSpecParameter(
                "schema_inference_mode",
                YTree.stringNode(schemaInferenceMode)
        );
        return this;
    }
}
