package ru.yandex.crypta.graph2.dao.yt.ops;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.common.JavaOptions;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.reduce.Reducer;
import ru.yandex.inside.yt.kosher.operations.specs.ReduceSpec;
import ru.yandex.inside.yt.kosher.operations.specs.ReducerSpec;
import ru.yandex.misc.dataSize.DataSize;


public class ReduceOperation extends RichYtOperation {

    // assumes 4MB/s job takes ~3min
    public static final DataSize DEFAULT_REDUCE_DATA_SIZE_PER_JOB = DataSize.fromMegaBytes(700);

    private static final Logger LOG = LoggerFactory.getLogger(ReduceOperation.class);

    private Yt yt;

    private ReduceSpec.Builder reduceSpecBuilder;
    private ReducerSpec.Builder reducerSpecBuilder;

    private ListF<String> reduceBy;

    public ReduceOperation(Yt yt, ListF<YPath> inputTables, ListF<YPath> outputTables, ListF<String> reduceBy,
                           Reducer reducer) {
        this.yt = yt;
        this.reduceBy = reduceBy;

        reducerSpecBuilder = ReducerSpec.builder()
                .setReducer(reducer)
                .setJobTimeLimit(Option.of(DEFENSIVE_JOB_TIME_LIMIT.toMillis()).getOrNull())
                .setMemoryLimit(ru.yandex.inside.yt.kosher.common.DataSize.fromBytes(DEFENSIVE_REDUCER_MEMORY_LIMIT.toBytes()))
                .setJavaOptions(JavaOptions.empty()
                        .withXmx(ru.yandex.inside.yt.kosher.common.DataSize.fromBytes(DEFAULT_REDUCER_MEMORY_LIMIT.toBytes()))
                        .withOption(LOCAL_LIBRARY_PATH_OPTION) // allows operation to lookup uploaded .so files locally
                );

        reduceSpecBuilder = ReduceSpec.builder()
                .setInputTables(inputTables)
                .setOutputTables(outputTables)
                .setReduceBy(reduceBy)
                .setDataSizePerJob(ru.yandex.inside.yt.kosher.common.DataSize.fromBytes(DEFAULT_REDUCE_DATA_SIZE_PER_JOB.toBytes()));

        String scriptName = CurrentScriptName.get();
        setScriptName(reduceSpecBuilder, scriptName);

    }

    public ReduceSpec.Builder getReduceSpecBuilder() {
        return reduceSpecBuilder;
    }

    public ReducerSpec.Builder getReducerSpecBuilder() {
        return reducerSpecBuilder;
    }

    @Override
    public Operation runAndGetOp(Option<GUID> transactionId) {
        ReducerSpec reducerSpec = reducerSpecBuilder.build();
        String description = reducerSpec.getMapperOrReducerTitle() + "[" + reduceBy.mkString(",") + "]";
        LOG.info("Starting reduce " + description);

        reduceSpecBuilder.setReducerSpec(reducerSpec);
        return yt.operations().reduceAndGetOp(transactionId.toOptional(), true, reduceSpecBuilder.build());
    }


}
