package ru.yandex.crypta.graph2.dao.yt.ops;

import java.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.crypta.graph2.utils.NativeLibHelper;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.SystemOperationSpecBase;
import ru.yandex.inside.yt.kosher.operations.specs.UserOperationSpecBase;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.misc.dataSize.DataSize;

public abstract class RichYtOperation {

    public static final String LOCAL_LIBRARY_PATH_OPTION = "-D" + NativeLibHelper.JAVA_LIBRARY_PATH + "=.";
    static final Duration DEFENSIVE_JOB_TIME_LIMIT = Duration.ofHours(2);

    static final DataSize DEFAULT_REDUCER_MEMORY_LIMIT = DataSize.fromMegaBytes(1500);
    static final DataSize DEFENSIVE_REDUCER_MEMORY_LIMIT = DEFAULT_REDUCER_MEMORY_LIMIT
            // additional gap above the default Xmx to avoid OOM
            .plus(DataSize.fromMegaBytes(400));

    protected abstract Operation runAndGetOp(Option<GUID> transactionId);

    public void runSync(Option<GUID> transactionId) {
        Await.op(runAndGetOp(transactionId));
    }

    public void runSync(GUID transactionId) {
        runSync(Option.of(transactionId));
    }

    public void runSync() {
        runSync(Option.empty());
    }

    public Function0<Operation> runAsync(Option<GUID> transactionId) {
        return () -> runAndGetOp(transactionId);
    }

    public Function0<Operation> runAsync(GUID transactionId) {
        return runAsync(Option.of(transactionId));
    }

    public Function0<Operation> runAsync() {
        return runAsync(Option.empty());
    }

    private YTreeMapNode getScriptNameSpec(String scriptName) {
        return YTree.builder()
                .beginMap()
                .key("script_name")
                .value(YTree.stringNode(scriptName))
                .buildMap();
    }

    protected void setScriptName(UserOperationSpecBase.Builder<?> specBuilder, String scriptName) {
        if (scriptName != null) {
            YTreeMapNode scriptNameKV = getScriptNameSpec(scriptName);
            specBuilder.plusAdditionalSpecParameter("annotations", scriptNameKV);
        }
    }

    protected void setScriptName(SystemOperationSpecBase.Builder<?> specBuilder, String scriptName) {
        if (scriptName != null) {
            YTreeMapNode scriptNameKV = getScriptNameSpec(scriptName);
            specBuilder.plusAdditionalSpecParameter("annotations", scriptNameKV);
        }
    }
}
