package ru.yandex.crypta.graph2.dao.yt.ops;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.SortSpec;
import ru.yandex.misc.lang.Check;

public class SortOperation extends RichYtOperation {

    private static final Logger LOG = LoggerFactory.getLogger(SortOperation.class);

    private Yt yt;

    private SortSpec.Builder sortSpecBuilder;
    private String description;

    public SortOperation(Yt yt, ListF<YPath> source, YPath target, ListF<String> keys) {
        this.yt = yt;

        Check.notEmpty(source);
        Check.notNull(target);
        Check.notEmpty(keys);

        target = target.withAdditionalAttributes(Cf.map("optimize_for", YTree.stringNode("scan")));

        sortSpecBuilder = SortSpec.builder()
                .setInputTables(source)
                .setOutputTable(target)
                .setSortBy(keys);

        if (source.size() == 1 && source.first().equals(target)) {
            description = String.format("Sorting %s by %s", source, keys);
        } else {
            description = String.format("Sorting %s to %s by %s", source, target, keys);
        }

        String scriptName = CurrentScriptName.get();
        setScriptName(sortSpecBuilder, scriptName);
    }

    public SortSpec.Builder getSortSpecBuilder() {
        return sortSpecBuilder;
    }

    public SortOperation withSchemaInferenceMode(String schemaInferenceMode) {
        sortSpecBuilder.plusAdditionalSpecParameter(
                "schema_inference_mode",
                YTree.stringNode(schemaInferenceMode)
        );
        return this;
    }

    @Override
    public Operation runAndGetOp(Option<GUID> transactionId) {
        LOG.info("Starting operation: " + description);
        return yt.operations().sortAndGetOp(transactionId.toOptional(), false, sortSpecBuilder.build());
    }


}
