package ru.yandex.crypta.graph2.dao.yt.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.operations.reduce.Reducer;

public interface YtOps {

    // === reduce ops ===
    ReduceOperation reduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                    ListF<String> reduceBy, Reducer reducer);

    default void reduceSync(ListF<YPath> inputTables, ListF<YPath> outputTables,
                            ListF<String> reduceBy, Reducer reducer) {
        reduceOperation(inputTables, outputTables, reduceBy, reducer).runSync();
    }

    default void reduceSync(GUID transactionId, ListF<YPath> inputTables, ListF<YPath> outputTables,
                            ListF<String> reduceBy, Reducer reducer) {
        reduceOperation(inputTables, outputTables, reduceBy, reducer).runSync(transactionId);
    }

    default Function0<Operation> reduceAsync(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                             ListF<String> reduceBy, Reducer reducer) {
        return reduceOperation(inputTables, outputTables, reduceBy, reducer).runAsync();
    }

    // === join reduce ===
    JoinReduceOperation joinReduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                            ListF<String> joinBy, Reducer reducer);

    default void joinReduceSync(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                ListF<String> joinBy, Reducer reducer) {
        joinReduceOperation(inputTables, outputTables, joinBy, reducer).runSync();
    }

    default void joinReduceSync(GUID transactionId, ListF<YPath> inputTables, ListF<YPath> outputTables,
                                ListF<String> joinBy, Reducer reducer) {
        joinReduceOperation(inputTables, outputTables, joinBy, reducer).runSync(transactionId);
    }

    default Function0<Operation> joinReduceAsync(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                                 ListF<String> joinBy, Reducer reducer) {
        return joinReduceOperation(inputTables, outputTables, joinBy, reducer).runAsync();
    }

    // === map ops ===
    MapOperation mapOperation(ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper);

    default void mapSync(ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper) {
        mapOperation(inputTables, outputTables, mapper).runSync();
    }

    default void mapSync(Option<GUID> transactionId, ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper) {
        mapOperation(inputTables, outputTables, mapper).runSync(transactionId);
    }

    default Function0<Operation> mapAsync(ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper) {
        return mapOperation(inputTables, outputTables, mapper).runAsync();
    }

    default Function0<Operation> mapAsync(Option<GUID> transactionId, ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper) {
        return mapOperation(inputTables, outputTables, mapper).runAsync(transactionId);
    }

    // === map ops ===
    MapReduceOperation mapReduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                          Mapper mapper, ListF<String> reduceBy, Reducer reducer);

    default void mapReduceSync(Option<GUID> transactionId, ListF<YPath> inputTables, ListF<YPath> outputTables,
                               Mapper mapper, ListF<String> reduceBy, Reducer reducer) {
        mapReduceOperation(inputTables, outputTables, mapper, reduceBy, reducer).runSync(transactionId);
    }

    // === sort ops ===
    SortOperation sortOperation(ListF<YPath> source, YPath target, ListF<String> keys);

    default void sortSync(YPath path, ListF<String> keys) {
        sortOperation(Cf.list(path), path, keys).runSync();
    }

    default void sortSync(Option<GUID> transactionId, YPath path, ListF<String> keys) {
        sortOperation(Cf.list(path), path, keys).runSync(transactionId);
    }

    default void sortSync(Option<GUID> transactionId, YPath source, YPath target, ListF<String> keys) {
        sortOperation(Cf.list(source), target, keys).runSync(transactionId);
    }

    default void sortSync(Option<GUID> transactionId, ListF<YPath> source, YPath target, ListF<String> keys) {
        sortOperation(source, target, keys).runSync(transactionId);
    }

    default Function0<Operation> sortAsync(YPath source, YPath target, ListF<String> keys) {
        return sortOperation(Cf.list(source), target, keys).runAsync();
    }

    default Function0<Operation> sortAsync(Option<GUID> transactionId, ListF<YPath> source, YPath target, ListF<String> keys) {
        return sortOperation(source, target, keys).runAsync(transactionId);
    }

    default void sortAllParallel(ListF<YPath> paths, ListF<String> keys) {
        Await.all(paths.map(path ->
                sortAsync(path, path, keys)
        ));
    }

    MergeOperation mergeChunksOperation(ListF<YPath> inTables, YPath outTable);

    default Function0<Operation> mergeChunksAsync(Option<GUID> transaction, YPath inTable, YPath outTable) {
        MergeOperation op = mergeChunksOperation(Cf.list(inTable), outTable);
        return op.runAsync(transaction);
    }

    default void mergeWithSchemaFromOutput(Option<GUID> transaction, ListF<YPath> tables, YPath outputTable) {
        MergeOperation op = mergeChunksOperation(tables, outputTable)
                .withSchemaInferenceMode("from_output");
        op.runSync(transaction);
    }

}
