package ru.yandex.crypta.graph2.dao.yt.ops;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.operations.reduce.Reducer;

public class YtOpsImpl implements YtOps {

    private Yt yt;
    private YtOpsParams ytOpsParams;

    public YtOpsImpl(Yt yt, YtOpsParams ytOpsParams) {
        this.yt = yt;
        this.ytOpsParams = ytOpsParams;
    }

    @Override
    public ReduceOperation reduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                           ListF<String> reduceBy, Reducer reducer) {
        ReduceOperation op = new ReduceOperation(yt, inputTables, outputTables, reduceBy, reducer);

        if (ytOpsParams.getOverrideReduceJobCount() != null) {
            op.getReduceSpecBuilder().setJobCount(ytOpsParams.getOverrideReduceJobCount());
        }

        return op;
    }

    @Override
    public JoinReduceOperation joinReduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                                   ListF<String> joinBy, Reducer reducer) {
        JoinReduceOperation op = new JoinReduceOperation(yt, inputTables, outputTables, joinBy, reducer);

        if (ytOpsParams.getOverrideReduceJobCount() != null) {
            op.getReduceSpecBuilder().setJobCount(ytOpsParams.getOverrideReduceJobCount());
        }

        return op;
    }


    @Override
    public MapOperation mapOperation(ListF<YPath> inputTables, ListF<YPath> outputTables, Mapper mapper) {
        MapOperation op = new MapOperation(yt, inputTables, outputTables, mapper);

        if (ytOpsParams.getOverrideMapJobCount() != null) {
            op.getMapSpecBuilder().setJobCount(ytOpsParams.getOverrideMapJobCount());
        }

        return op;
    }

    @Override
    public MapReduceOperation mapReduceOperation(ListF<YPath> inputTables, ListF<YPath> outputTables,
                                                 Mapper mapper, ListF<String> reduceBy, Reducer reducer) {

        MapReduceOperation op = new MapReduceOperation(yt, inputTables, outputTables, mapper, reduceBy, reducer);

        if (ytOpsParams.getOverrideMapJobCount() != null) {
            // ??
            op.getMapReduceSpecBuilder().setMapJobCount(ytOpsParams.getOverrideMapJobCount());
            op.getMapReduceSpecBuilder().setPartitionJobCount(ytOpsParams.getOverrideReduceJobCount());
            op.getMapReduceSpecBuilder().setSortJobCount(ytOpsParams.getOverrideSortJobCount());
        }

        return op;
    }

    @Override
    public SortOperation sortOperation(ListF<YPath> source, YPath target, ListF<String> keys) {

        SortOperation op = new SortOperation(yt, source, target, keys);

        if (ytOpsParams.getOverrideSortJobCount() != null) {
            op.getSortSpecBuilder().setPartitionJobCount(ytOpsParams.getOverrideSortJobCount());
            op.getSortSpecBuilder().setSortJobCount(ytOpsParams.getOverrideSortJobCount());
        }

        return op;
    }

    @Override
    public MergeOperation mergeChunksOperation(ListF<YPath> inTables, YPath outTable) {
        return new MergeOperation(yt, inTables, outTable);
    }


}
