package ru.yandex.crypta.graph2.dao.yt.proto;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;

import ru.yandex.crypta.graph.soup.config.ProtobufEnum;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeSerializer;
import ru.yandex.inside.yt.kosher.ytree.YTreeEntityNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.type_info.TiType;
import ru.yandex.yson.YsonConsumer;

public class ProtobufEnumToNameSerializer<E extends Enum<E> & ProtocolMessageEnum, M extends Message> implements YTreeSerializer<E> {

    private ProtobufEnum<E, M> byNameResolver;

    public ProtobufEnumToNameSerializer(ProtobufEnum<E, M> byNameResolver) {
        this.byNameResolver = byNameResolver;
    }

    @Override
    public void serialize(E obj, YsonConsumer consumer) {
        consumer.onString(byNameResolver.typeToName(obj));
    }

    @Override
    public E deserialize(YTreeNode node) {
        if (node instanceof YTreeEntityNode) {
            return null;
        }
        return byNameResolver.nameToType(node.stringValue());
    }

    @Override
    public TiType getColumnValueType() {
        return TiType.string();
    }
}
