package ru.yandex.crypta.graph2.dao.yt.schema.extractor;

import java.util.LinkedHashSet;
import java.util.List;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.TableSchema;

public abstract class AbstractYtSchemaExtractor implements YtSchemaExtractor {

    protected abstract <T> List<ColumnSchema> extractColumns(Class<T> aClass);

    @Override
    public <T> TableSchema extractTableSchema(Class<T> aClass) {
        TableSchema.Builder builder = new TableSchema.Builder().setUniqueKeys(false).setStrict(true);

        for (ColumnSchema column : extractColumns(aClass)) {
            builder.add(column);
        }

        return builder.build();
    }


    @Override
    public <T> TableSchema extractUnionTableSchema(ListF<Class<? extends T>> classes) {
        TableSchema.Builder builder = new TableSchema.Builder().setUniqueKeys(false).setStrict(true);

        LinkedHashSet<ColumnSchema> deduplicated = new LinkedHashSet<>();
        for (Class<? extends T> aClass : classes) {
            deduplicated.addAll(extractColumns(aClass));
        }

        deduplicated.forEach(builder::add);

        return builder.build();
    }
}
