package ru.yandex.crypta.graph2.dao.yt.schema.extractor;

import java.util.List;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.AccessorExtractor;
import ru.yandex.misc.bender.Accessors;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

public class BenderYtSchemaExtractor extends AbstractYtSchemaExtractor {

    protected ColumnValueType primitiveClassToYsonType(TypeX type) {
        Class clazz = type.erasure().wrapPrimitiveSafe().getClazz();
        if (clazz.equals(Integer.class) || clazz.equals(Long.class)) {
            return ColumnValueType.INT64;
        } else if (clazz.equals(Float.class) || clazz.equals(Double.class)) {
            return ColumnValueType.DOUBLE;
        } else if (clazz.equals(String.class) || StringEnum.class.isAssignableFrom(clazz)) {
            return ColumnValueType.STRING;
        } else if (clazz.equals(Boolean.class)) {
            return ColumnValueType.BOOLEAN;
        } else if (clazz.equals(Option.class)) {
            TypeX optionGenericType = type.getActualTypeArguments().first();
            return primitiveClassToYsonType(optionGenericType);
        } else {
            return ColumnValueType.ANY;
        }
    }

    protected void fieldsToYsonColumns(List<FieldX> fields, Consumer<ColumnSchema> typesConsumer) {
        for (FieldX field : fields) {
            if (field.hasAnnotation(BenderFlatten.class)) {
                for (FieldX nestedField : field.getType().getAllDeclaredFields()) {
                    // recursively dangerous
                    fieldsToYsonColumns(Cf.list(nestedField), typesConsumer);
                }
            } else if (field.hasAnnotation(BenderPart.class)) {
                BenderPart benderPart = field.getAnnotation(BenderPart.class);
                String columnName;
                if (StringUtils.isEmpty(benderPart.name())) {
                    columnName = field.getName();
                } else {
                    columnName = benderPart.name();
                }
                ColumnValueType columnType = primitiveClassToYsonType(field.getGenericType());
                typesConsumer.accept(new ColumnSchema(columnName, columnType));
            }
        }
    }

    @Override
    protected <T> List<ColumnSchema> extractColumns(Class<T> aClass) {
        ClassX<T> aClassX = ClassX.wrap(aClass);
        AccessorExtractor fieldExtractor = AccessorExtractor.cons(aClassX, MembersToBind.WITH_ANNOTATIONS);
        Accessors accessors = fieldExtractor.extract(aClassX);

        List<ColumnSchema> result = Cf.arrayList();
        fieldsToYsonColumns(accessors.getFields(), result::add);
        return result;
    }

}
