package ru.yandex.crypta.graph2.dao.yt.schema.extractor;

import java.util.ArrayList;
import java.util.List;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Descriptors.Descriptor;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.Message;

import ru.yandex.inside.yt.kosher.utils.ProtoUtils;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

public class ProtobufYtSchemaExtractor extends AbstractYtSchemaExtractor {

    @Override
    protected <T> List<ColumnSchema> extractColumns(Class<T> aClass) {
        if (!Message.class.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("Class is not a protobuf message: " + aClass.getName());
        }
        Class<? extends Message> messageClass = aClass.asSubclass(Message.class);
        Descriptor descriptor = ProtoUtils.getDescriptor(messageClass);

        List<ColumnSchema> columns = new ArrayList<>();
        for (Descriptors.FieldDescriptor d : descriptor.getFields()) {
            String name = d.getName();
            FieldDescriptor.Type type = d.getType();

            String columnName = d.toProto().getOptions().getExtension(NYT.Extension.columnName);
            String keyColumnName = d.toProto().getOptions().getExtension(NYT.Extension.keyColumnName);

            if (!columnName.isEmpty()) {
                name = columnName;
            } else if (!keyColumnName.isEmpty()) {
                name = keyColumnName;
            }

            columns.add(new ColumnSchema(
                    name,
                    convertProtobufToYtType(type)
            ));
        }
        return columns;
    }

    private ColumnValueType convertProtobufToYtType(FieldDescriptor.Type type) {
        switch (type) {
            case DOUBLE:
                return ColumnValueType.DOUBLE;
            case INT64:
            case INT32:
            case ENUM:
                return ColumnValueType.INT64;
            case UINT64:
            case UINT32:
                return ColumnValueType.UINT64;
            case BOOL:
                return ColumnValueType.BOOLEAN;
            case STRING:
            case BYTES:

            case MESSAGE:
                // complex fields a represented as bytes and are stored in STRING type
                return ColumnValueType.STRING;
            default:
                throw new IllegalArgumentException("Can't find corresponding yt type for " + type);

        }

    }


}
