package ru.yandex.crypta.graph2.dao.yt.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeEntityNodeImpl;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeMapNodeImpl;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeEntityNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class YTreeUtils {

    public static final YTreeEntityNode YSON_NULL = new YTreeEntityNodeImpl(Cf.map());

    public static <T extends YTreeNode> Optional<T> getNullableNode(YTreeMapNode node, String column) {
        Optional<YTreeNode> value = node.get(column);
        return value.flatMap(v -> {
            if (v.isEntityNode()) {
                return Optional.empty();
            } else {
                return Optional.of(v.cast());
            }
        });

    }

    /**
     * Extracts List<String> from yson, returns empty list if null
     */
    public static List<String> getStringList(YTreeMapNode rec, String column) {
        return rec.getListO(column).map(yson ->
                yson
                        .asList()
                        .stream()
                        .map(YTreeNode::stringValue)
                        .collect(Collectors.toList())
        ).orElse(List.of());
    }

    /**
     * Hack for stupid yson key-string-only maps
     */
    public static <K, V> MapF<String, V> typedKeyToString(MapF<K, V> map) {
        return map.entries().map1(String::valueOf).toMap();
    }

    /**
     * Hack for stupid yson key-string-only maps
     */
    public static <V> MapF<Integer, V> stringKeyToInt(MapF<String, V> map) {
        return map.entries().map1(Integer::parseInt).toMap();
    }

    /**
     * Heavy operation!!
     */
    public static YTreeMapNode deepCopyRec(YTreeMapNode rec) {
        return YTree.builder().value(rec).build().mapNode();
    }

    public static YTreeMapNode shallowCopyRec(YTreeMapNode rec, boolean keepAttrs) {
        Map<String, YTreeNode> innerCopy = rec.asMap();

        Map<String, YTreeNode> attributes;
        if (keepAttrs) {
            attributes = rec.getAttributes();
        } else {
            attributes = null;
        }
        return new YTreeMapNodeImpl(innerCopy, attributes);
    }
}
