package ru.yandex.crypta.graph2.utils;

import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.StringUtils;

public class EnvUtils {

    public static String getEnvOrThrow(String varName) {
        String envVar = System.getenv(varName);
        Check.notEmpty(envVar, String.format("%s is not defined in ENV", varName));
        return envVar;
    }

    public static String getEnvOrDefault(String varName, String def) {
        String envVar = System.getenv(varName);
        if (StringUtils.isEmpty(envVar)) {
            return def;
        } else {
            return envVar;
        }
    }

    public static int getIntEnvOrDefault(String varName, int def) {
        String envVar = System.getenv(varName);
        if (StringUtils.isEmpty(envVar)) {
            return def;
        } else {
            return Integer.parseInt(envVar);
        }
    }
}
