package ru.yandex.crypta.graph2.utils;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;

public class FreqUtils {

    public static <T> Option<T> getMostFrequent(CollectionF<T> input) {
        return getKeyWithBestValue(input.countBy());
    }

    public static <T> Option<T> getMostFrequentOrEmptyIfNotSingle(CollectionF<T> input) {
        MapF<T, Integer> counts = input.countBy();
        Option<Tuple2<T, Integer>> resultItem = counts.entries().maxByO(Tuple2::get2);
        if (!resultItem.isPresent()) {
            return Option.empty();
        }
        int maxCount = resultItem.get()._2;
        if (counts.filter(k -> k._2 == maxCount).size() > 1) {
            return Option.empty();
        }
        return Option.of(resultItem.get()._1);
    }

    public static <K, V> Option<K> getKeyWithBestValue(MapF<K, V> input) {
        return input.entries()
                .maxByO(Tuple2::get2)
                .map(Tuple2::get1);
    }
}
