package ru.yandex.crypta.graph2.utils;

import java.nio.charset.StandardCharsets;

import com.sangupta.murmur.Murmur2;

public class HashUtils {

    /**
     * NOTE: returns SIGNED int64
     */
    public static long arcadiaCompatibleMurmurInt64(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return Murmur2.hash64(bytes, bytes.length, 0);
    }

    public static String arcadiaCompatibleMurmurUint64String(String value) {
        long hash = arcadiaCompatibleMurmurInt64(value);
        return Long.toUnsignedString(hash);
    }

}
