package ru.yandex.crypta.graph2.utils;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.impl.AbstractPrefetchingIterator;
import ru.yandex.bolts.function.Function1B;

public class IteratorUtils {

    public static <E> IteratorSplit<E> takeWhile(IteratorF<E> source, Function1B<? super E> f) {
        return takeWhileWithLimit(source, f, -1);
    }

    public static <E> IteratorSplit<E> takeWhileWithLimit(IteratorF<E> source, Function1B<? super E> f, int limit) {

        class TakeWhileIterator extends AbstractPrefetchingIterator<E> {
            private boolean end = false;
            private Option<E> prefetched = Option.empty();  // in fact, this is the same as next of super class, but
            private int count = 0;
            private boolean limitReached = false;

            @Override
            protected Option<E> fetchNext() {
                if (!end && source.hasNext()) {
                    if (limit >= 0 && count >= limit) {
                        limitReached = true;
                        end = true;
                        return Option.empty();
                    }
                    prefetched = Option.of(source.next());
                    if (f.apply(prefetched.get())) {
                        count++;
                        return prefetched;
                    } else {
                        end = true;
                        return Option.empty();
                    }
                }
                return Option.empty();
            }

            public boolean isLimitReached() {
                return this.limitReached;
            }

        }

        IteratorSplit<E> result = new IteratorSplit<>();

        TakeWhileIterator headIter = new TakeWhileIterator();
        result.head = headIter.toList();
        result.limitReached = headIter.limitReached;

        if (headIter.end && headIter.prefetched.isPresent()) {
            result.tail = headIter.prefetched.iterator().plus(source);
        } else {
            result.tail = source;
        }

        return result;
    }

    public static <E> IteratorSplit<E> takeWhile(CollectionF<E> source, Function1B<? super E> f) {
        return takeWhile(source.iterator(), f);
    }

    public static class IteratorSplit<T> {
        private ListF<T> head;
        private IteratorF<T> tail;
        private boolean limitReached;

        public ListF<T> getHead() {
            return head;
        }

        public IteratorF<T> getTail() {
            return tail;
        }

        public boolean isLimitReached() {
            return limitReached;
        }
    }

    public static <T> Tuple2<IteratorF<T>, Boolean> checkOverlimit(IteratorF<T> recs, int limit) {
        ListF<T> firstN = recs.take(limit).toList();
        if (firstN.size() == limit) {
            IteratorF<T> iter = firstN.iterator().plus(recs);
            return Tuple2.tuple(iter, true);
        } else {
            return Tuple2.tuple(firstN.iterator(), false);
        }
    }

    public static <E> Stream<E> stream(Iterator<E> iter) {
        Spliterator<E> spliterator = Spliterators.spliteratorUnknownSize(iter, 0);
        return StreamSupport.stream(spliterator, false);
    }


}
