package ru.yandex.crypta.graph2.utils;

import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;

public class LoggingConsumer<E> implements Consumer<E> {

    private static final Logger LOG = LoggerFactory.getLogger(LoggingConsumer.class);
    private final int logIntervalRecs;
    private CollectionF<E> innerContainer = Cf.hashSet();
    private int recsConsumed = 0;

    public LoggingConsumer() {
        this.logIntervalRecs = 10000;
    }

    public LoggingConsumer(int logIntervalRecs) {
        this.logIntervalRecs = logIntervalRecs;
    }

    public LoggingConsumer(CollectionF<E> innerContainer, int logIntervalRecs) {
        this.innerContainer = innerContainer;
        this.logIntervalRecs = logIntervalRecs;
    }

    @Override
    public void accept(E e) {
        innerContainer.add(e);
        if (recsConsumed % logIntervalRecs == 0) {
            LOG.info(String.format("Read %d recs", recsConsumed));
        }
        recsConsumed++;
    }

    public CollectionF<E> getResult() {
        return innerContainer;
    }
}
