package ru.yandex.crypta.graph2.utils;

import java.lang.reflect.Field;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibHelper {

    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibHelper.class);

    public static void setLocalJavaLibraryPath() {
        setLocalJavaLibraryPath(".");
    }

    public static void appendLocalToJavaLibraryPath() {
        String javaLibraryPath = getJavaLibraryPath();
        if (javaLibraryPath != null && !javaLibraryPath.isEmpty()) {
            setLocalJavaLibraryPath(javaLibraryPath + ":.");
        } else {
            setLocalJavaLibraryPath(".");
        }
    }

    public static String getJavaLibraryPath() {
        return System.getProperty(JAVA_LIBRARY_PATH);
    }

    public static void setLocalJavaLibraryPath(String path) {

        LOG.warn("Overriding {} to {}", JAVA_LIBRARY_PATH, path);

        System.setProperty(JAVA_LIBRARY_PATH, path);

        // ClassLoader library path may have already been initialized, need to reset it
        try {
            // http://fahdshariff.blogspot.com/2011/08/changing-java-library-path-at-runtime.html
            final Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            LOG.error("Can't override " + JAVA_LIBRARY_PATH, e);
        }
    }


}
