package ru.yandex.crypta.graph2.utils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;

public class SetUtils {

    public static <T> SetF<T> symmetricDifference(SetF<T> s1, SetF<T> s2) {
        SetF<T> diff12 = s1.minus(s2);
        SetF<T> diff21 = s2.minus(s1);
        SetF<T> result = Cf.hashSetWithExpectedSize(diff12.size() + diff21.size());
        result.addAll(diff12);
        result.addAll(diff21);
        return result;
    }
}
