package ru.yandex.crypta.graph2.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlConfig {

    private static final Logger LOG = LoggerFactory.getLogger(YamlConfig.class);

    public static <T> T readConfigFromFile(String absoluteFileName, Class<T> configClass) {
        File file = Paths.get(absoluteFileName).toFile();
        return readConfigFromFile(file, configClass);
    }

    public static <T> T readConfigFromClassPath(String resoucesName, Class<T> configClass) {
        URL classPathResource = configClass.getClassLoader().getResource(resoucesName);
        if (classPathResource == null) {
            throw new IllegalArgumentException("Resource not found: " + resoucesName);
        }
        File file = new File(classPathResource.getFile());
        return readConfigFromFile(file, configClass);
    }

    private static <T> T readConfigFromFile(File file, Class<T> configClass) {
        ObjectMapper yamlConfigParser = new ObjectMapper(new YAMLFactory());
        yamlConfigParser.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

        try {
            LOG.info("Parsing config file {}", file.getAbsolutePath());
            return yamlConfigParser.readValue(file, configClass);
        } catch (IOException e) {
            throw new IllegalArgumentException(String.format(
                    "Can't parse config file %s -> %s", file.getAbsolutePath(), configClass.getSimpleName()
            ), e);
        }
    }


}
