package ru.yandex.crypta.graph2.workflow;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.inside.yt.kosher.cypress.YPath;

abstract public class DestinationsInspector {

    abstract public void markDestination(Dao dao, YPath path);

    abstract public boolean isReady(Dao dao, YPath path);

    public void markDestinations(Dao dao, Iterable<YPath> paths) {
        for (YPath path : paths) {
            markDestination(dao, path);
        }
    }

    public boolean areReady(Dao dao, Iterable<YPath> paths) {
        for (YPath path : paths) {
            if (!isReady(dao, path)) {
                return false;
            }
        }
        return true;
    }
}
