package ru.yandex.crypta.graph2.workflow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public abstract class SkippableTask<InTables, OutTables extends Iterable<YPath>, Params> extends Task<InTables, OutTables, Params> {
    private static final Logger LOG = LoggerFactory.getLogger(SkippableTask.class);
    protected DestinationsInspector destinationsInspector;

    protected SkippableTask(Dao dao, YPath workdir, Params params, String nameSuffix, DestinationsInspector destinationsInspector)
    {
        super(dao, workdir, params, nameSuffix);
        this.destinationsInspector = destinationsInspector;
    }

    protected boolean canSkipRunPhase() {
        // use for ready destinations
        // to avoid double running

        if (destinationsInspector != null) {
            return destinationsInspector.areReady(dao, getOutput());
        }

        return false;
    }

    protected void markDestinations() {
        LOG.info("mark destinations {}", workdir);
        if (destinationsInspector != null) {
            destinationsInspector.markDestinations(dao, getOutput());
        }
    }

    @Override
    public void run(InTables inTables) {
        if (canSkipRunPhase()) {
            LOG.info("skip {}", workdir);
            return;
        }
        super.run(inTables);
        markDestinations();
    }
}
