#include "util.h"

bool IsYuidPrivate(const TString& date, const TString& yuid) {
    time_t dayBegin;
    time_t dayEnd;
    ParseISO8601DateTime((date + TString("T00:00:00Z")).data(), dayBegin);
    ParseISO8601DateTime((date + TString("T23:59:59Z")).data(), dayEnd);
    TString suffix(yuid.begin() + std::max(0, static_cast<int>(yuid.size() - 10)), yuid.end());
    time_t yuidTimestamp = FromString<time_t>(suffix);
    time_t timezoneShift = TDuration::Hours(3).Seconds();
    if ((dayBegin <= yuidTimestamp + timezoneShift) && (yuidTimestamp + timezoneShift <= dayEnd)) {
        return true;
    }
    return false;
}

bool IsPrivate(const TNode::TListType& dates, const TString& yuid) {
    if (dates.size() != 1) {
        return false;
    }
    return IsYuidPrivate(dates.back().AsString().data(), yuid);
}
