"""Task DirectMainTask.
   Main task for run Direct
"""

import datetime

import crypta.lib.python.bt.conf.conf as conf
from cached_property import cached_property

from crypta.lib.python.bt.tasks import YtTask
from crypta.lib.python.bt.workflow import IndependentTask

from crypta.graph.matching.direct.lib.direct import DirectByTypes
from crypta.graph.publish.lib.direct_link_publisher import DirectLinkPublisher


class DirectMainTask(YtTask, IndependentTask):
    def requires(self):
        return iter([
            DirectByTypes(run_date=self.run_date, generate_date=self.generate_date)
        ])

    @cached_property
    def run_date(self):
        return datetime.datetime.now().strftime("%Y-%m-%d")

    @cached_property
    def generate_date(self):
        edges_by_crypta_id = conf.direct_config.paths.direct.edges_by_crypta_id
        return self.yt.get_attribute(edges_by_crypta_id, "generate_date")

    def run(self, **kwargs):
        DirectLinkPublisher(yt=self.yt, run_date=self.run_date, generate_date=self.generate_date).run()
