#pragma once

#include <crypta/graph/lib/util/util.h>
#include <crypta/graph/soup/config/cpp/soup_config.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>
#include <mapreduce/yt/interface/client.h>
#include <util/generic/map.h>
#include <util/generic/set.h>
#include <util/generic/queue.h>
#include <util/generic/utility.h>
#include <util/generic/list.h>
#include <util/generic/vector.h>
#include <util/generic/set.h>
#include <util/generic/hash.h>

#include <crypta/graph/matching/direct/proto/types.pb.h>


using namespace NYT;
using namespace NCrypta::NSoup;
using namespace NCrypta::NIdentifiersProto;
using namespace NDirect;

struct TVertex {
    NIdType::TIdType Type;
    TString Value;
};

inline bool operator<(const TVertex& lhs, const TVertex& rhs) {
    return std::make_tuple(lhs.Type.GetType(), lhs.Value) <
           std::make_tuple(rhs.Type.GetType(), rhs.Value);
}

inline bool operator==(const TVertex& lhs, const TVertex& rhs) {
    return std::make_tuple(lhs.Type.GetType(), lhs.Value) ==
           std::make_tuple(rhs.Type.GetType(), rhs.Value);
}

struct TBoundaryTimestamps {
    ui64 FirstTimestamp = 0;
    ui64 LastTimestamp = 0;

    TString GetDateBegin() const;
    TString GetDateEnd() const;
    bool IsEmpty() const;

    bool operator==(const TBoundaryTimestamps& second) const {
        return FirstTimestamp == second.FirstTimestamp && LastTimestamp == second.LastTimestamp;
    }
};

struct TEdge {
    NSourceType::TSourceType SourceType;
    NLogSource::TLogSourceType LogSource;

    TBoundaryTimestamps BoundaryTimestamps;
};

template <>
struct TLess<TEdgeType> {
    bool operator()(const TEdgeType& lhs, const TEdgeType& rhs) const {
        return std::make_tuple(lhs.GetId1Type(), lhs.GetId2Type(), lhs.GetSourceType(), lhs.GetLogSource()) <
               std::make_tuple(rhs.GetId1Type(), rhs.GetId2Type(), rhs.GetSourceType(), rhs.GetLogSource());
    }
};

struct TLinkedVertex {
    TVertex Vertex;
    TEdge Type;
};


const int DIRECT_BY_ID_AND_ID_TYPE_TABLE = 0;
const int DIRECT_YANDEXUID_BY_ID_TYPE_AND_ID_TABLE = 1;


class TTypesWithIndexes {
public:
    TTypesWithIndexes() {}

    TTypesWithIndexes(NNativeYT::TProtoState<NDirect::TTypesInfo>& State) {
        for (size_t i = 0; i < State->types_pairSize(); ++i) {
            TypesInfo[std::make_pair(State->Gettypes_pair(i).type_in(), State->Gettypes_pair(i).type_out())] = State->Gettypes_pair(i).index();
        }
    }
    bool Contains(const TString& firstType, const TString& secondType) const {
        return GetIndex(firstType, secondType) != -1;
    }

    int GetIndex(const TString& firstType, const TString& secondType) const {
        auto typePair = std::make_pair(
            to_lower(firstType),
            to_lower(secondType)
        );
        auto it = TypesInfo.find(typePair);
        if (it != TypesInfo.end()) {
            return it->second;
        }
        return -1;
    }

private:
    THashMap<std::pair<TString, TString>, int> TypesInfo{};
};

class TDirectReducer: public TStateful<NDirect::TTypesInfo, IReducer<TTableReader<TNode>, TTableWriter< ::google::protobuf::Message>>> {
public:
    TDirectReducer()
        : TStateful()
    {
    }
    TDirectReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }
    virtual void Do(TTableReader<TNode>* input, TWriter* output) override;
    void Start(TWriter*) override;

    using TOutputs = std::tuple<TDirectNeighbours, TDirectEdge, TDirectEdge>;

private:
    TTypesWithIndexes TypesInfo{};
};

class TDirectByTypesWithoutCryptaIdMapper: public TStateful<NDirect::TTypesInfo, IMapper<TTableReader<TDirectNeighbours>, TTableWriter<TDirectEdge>>> {
public:
    TDirectByTypesWithoutCryptaIdMapper()
        : TStateful()
    {
    }
    TDirectByTypesWithoutCryptaIdMapper(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TDirectNeighbours>* input, TTableWriter<TDirectEdge>* output) override;
    void Start(TTableWriter<TDirectEdge>*) override;
private:
    TTypesWithIndexes TypesInfo{};
};

class TDirectByCryptaIdMapper: public TStateful<NDirect::TTypesInfo, IMapper<TTableReader<TDirectEdge>, TTableWriter<TDirectEdge>>> {
public:
    TDirectByCryptaIdMapper()
        : TStateful()
    {
    }
    TDirectByCryptaIdMapper(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TDirectEdge>* input, TTableWriter<TDirectEdge>* output) override;
    void Start(TTableWriter<TDirectEdge>*) override;
private:
    TTypesWithIndexes TypesInfo{};
};

class TCryptaidsMatchingMapper: public IMapper<TTableReader<TSoupEdge>, TTableWriter<TDirectEdge>> {
public:
    void Do(TTableReader<TSoupEdge>* input, TTableWriter<TDirectEdge>* output) override;
};
