package ru.yandex.crypta.graph2.matching.human;

import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.LocalYtFactory;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class HumanMatchingMainLocalRun {

    public static void main(String[] args) {
        Dao localDao = LocalYtFactory.createFileBasedLocalDao(Paths.get("/Users/artembelov/dev/arcadia/crypta/graph/matching/human/src/test/resources/test_data"));
        Dao localDao2 = LocalYtFactory.createFileBasedLocalDao(Paths.get("/Users/artembelov/dev/arcadia/crypta/graph/matching/human/src/test/resources/test_data"));

        ListF<YTreeMapNode> recs = Cf.arrayList();
        localDao.yt().tables().read(YPath.simple("//soup_edges"), YTableEntryTypes.YSON, (Consumer<YTreeMapNode>) recs::add);

        recs = recs.map(r -> {
            Map<String, YTreeNode> x = r.asMap();
            x.put("datesWeight", x.get("weight"));
            x.put("survivalWeight", x.get("weight"));
            return YTree.builder().value(x).build().mapNode();
        });

        localDao2.yt().tables().write(YPath.simple("//soup_edges1"), YTableEntryTypes.YSON, recs.iterator());
    }
}
