package ru.yandex.crypta.graph2.matching.human.config;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.crypta.graph2.matching.human.paths.SoupTables;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ConfigParser {

    public static SoupTables parseSoupTables(HumanMatchingConfig config) {
        Option<YPath> soupEdgeMessagesTable = Option.empty();
        if (config.soupEdgeMessagesTable != null) {
            soupEdgeMessagesTable = Option.of(YPath.simple(config.soupEdgeMessagesTable));
        }
        return new SoupTables(
                YPath.simple(config.soupEdgesTable),
                YPath.simple(config.soupVerticesPropertiesTable),
                soupEdgeMessagesTable
        );
    }

    public static YtOpsParams parseYtParams(HumanMatchingConfig config) {
        if ("medium".equals(config.soupSize)) {
            // special case ops for small soup
            return new YtOpsParams(500, 500, 100);
        } else {
            return new YtOpsParams();
        }
    }

    public static List<TEdgeType> parseEdgeTypes(List<String> filterEdgeTypes) {
        if (filterEdgeTypes == null || filterEdgeTypes.isEmpty()) {
            return List.of();
        } else {
            return Soup.CONFIG.getEdgeTypes()
                    .stream()
                    .filter(et -> filterEdgeTypes.contains(Soup.CONFIG.getEdgeName(et)))
                    .collect(Collectors.toList());
        }
    }


}
