package ru.yandex.crypta.graph2.matching.human.config;

import java.util.List;

import ru.yandex.misc.lang.DefaultToString;

public class HumanMatchingConfig extends DefaultToString {

    public String componentScoringStrategy;
    public List<String> componentsSimilarityStrategies = List.of();
    public List<String> weakComponentsSimilarityStrategies = List.of();
    public String cryptaIdDispenser;
    public boolean forceMergeSingleVertexComponents;
    public String mergeType;
    public String mergeStrategy;
    public String splitStrategy;
    public String soupSize;
    public int edgesPerSourceLimit;
    public int mergeSizeLimit;
    public int recsComponentLimit;
    public NativeScoreOptions nativeScoreOptions = new NativeScoreOptions();

    public String soupEdgesTable;
    public String soupEdgeMessagesTable;
    public String soupEdgesBackwardsTable;
    public String soupVerticesPropertiesTable;
    public String soupVerticesPropertiesDynamicTable;
    public List<String> filterEdgeTypes;

    public String prevMatchingTable;
    public String workdir;
    public String outputDir;

    public String dictDir;

    public String localYtDir;

    public boolean doCleanup;
    public boolean joinHeavyColumnsToResultingTables;
    public boolean skipReadyTasks;
    // it means: skip task for ready destinations without changes in sources

    public static class NativeScoreOptions extends DefaultToString {
        public NativeScoreOptions() {}
        public double crossDeviceWeight = 8.5;
        public double socdemWeight = 0.;
    }
}
