package ru.yandex.crypta.graph2.matching.human.helper;

import java.util.Objects;

public class SimpleVertex {
    private final String idValue;
    private final String idType;

    public SimpleVertex(String idValue, String idType) {
        this.idValue = idValue;
        this.idType = idType;
    }

    public String getIdValue() {
        return idValue;
    }

    public String getIdType() {
        return idType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleVertex vertex)) {
            return false;
        }
        return Objects.equals(idValue, vertex.idValue) &&
                Objects.equals(idType, vertex.idType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idValue, idType);
    }
}
