package ru.yandex.crypta.graph2.matching.human.strategy;

import java.time.Instant;

import ru.yandex.crypta.graph2.model.matching.component.score.ComponentScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.graph.cryptaid.CryptaIdDispenser;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyType;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferPriority;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.matching.merge.algo.split.SplitAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.misc.lang.DefaultToString;

public class HumanMatchingStrategyProvider extends DefaultToString {

    private final EdgeInfoProvider edgeInfoProvider;
    private final CryptaIdDispenser cryptaIdDispenser;
    private final ComponentScoringStrategy componentScoringStrategy;
    private final MergeAlgorithm mergeAlgorithm;
    private final MergeAlgorithm experimentalMergeAlgorithm;
    private final SplitAlgorithm splitAlgorithm;
    private final MergeOfferPriority mergePriority;
    private final MergeKeyType mergeType;
    private boolean skipReadyTasks = false;
    private String runId;

    public HumanMatchingStrategyProvider(
            EdgeInfoProvider edgeInfoProvider,
            CryptaIdDispenser cryptaIdDispenser,
            ComponentScoringStrategy componentScoringStrategy,
            MergeAlgorithm mergeAlgorithm,
            MergeAlgorithm experimentalMergeAlgorithm,
            SplitAlgorithm splitAlgorithm,
            MergeOfferPriority mergePriority,
            MergeKeyType mergeType)
    {
        this.cryptaIdDispenser = cryptaIdDispenser;
        this.edgeInfoProvider = edgeInfoProvider;
        this.componentScoringStrategy = componentScoringStrategy;
        this.mergeAlgorithm = mergeAlgorithm;
        this.experimentalMergeAlgorithm = experimentalMergeAlgorithm;
        this.splitAlgorithm = splitAlgorithm;
        this.mergePriority = mergePriority;
        this.mergeType = mergeType;
        this.runId = String.valueOf(Instant.now().getEpochSecond());
    }

    public HumanMatchingStrategyProvider(
            EdgeInfoProvider edgeInfoProvider,
            CryptaIdDispenser cryptaIdDispenser,
            ComponentScoringStrategy componentScoringStrategy,
            MergeAlgorithm mergeAlgorithm,
            MergeAlgorithm experimentalMergeAlgorithm,
            SplitAlgorithm splitAlgorithm,
            MergeOfferPriority mergePriority,
            MergeKeyType mergeType,
            boolean skipReadyTasks)
    {
        this(
                edgeInfoProvider,
                cryptaIdDispenser,
                componentScoringStrategy,
                mergeAlgorithm,
                experimentalMergeAlgorithm,
                splitAlgorithm,
                mergePriority,
                mergeType
        );
        this.skipReadyTasks = skipReadyTasks;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public String getRunId() {return runId;}

    public boolean canSkipReadyTasks() {
        return skipReadyTasks;
    }

    public EdgeInfoProvider getEdgeInfoProvider() {
        return edgeInfoProvider;
    }

    public ComponentScoringStrategy getComponentScoringStrategy() {
        return componentScoringStrategy;
    }

    public MergeAlgorithm getMergeAlgorithm() {
        return mergeAlgorithm;
    }

    public MergeAlgorithm getExperimentalMergeAlgorithm() {
        return experimentalMergeAlgorithm;
    }

    public SplitAlgorithm getSplitAlgorithm() {
        return splitAlgorithm;
    }

    public CryptaIdDispenser getCryptaIdDispenser() {
        return cryptaIdDispenser;
    }

    public MergeKeyType getMergeType() {
        return mergeType;
    }

    public MergeOfferPriority getMergePriority() {
        return mergePriority;
    }
}
