package ru.yandex.crypta.graph2.matching.human.workflow;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.matching.human.strategy.HumanMatchingStrategyProvider;
import ru.yandex.crypta.graph2.workflow.DestinationsInspector;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class HumanDestinationsInspector extends DestinationsInspector {
    private static final String RUN_ID_ATTR = "run_id";
    private String runId;
    private boolean skipReadyTasks;

    public HumanDestinationsInspector(HumanMatchingStrategyProvider humanMatchingStrategyProvider) {
        skipReadyTasks = humanMatchingStrategyProvider.canSkipReadyTasks();
        runId = humanMatchingStrategyProvider.getRunId();
    }

    @Override
    public void markDestination(Dao dao, YPath path) {
        if (dao.yt().cypress().exists(path)) {
            dao.yt().cypress().set(path.attribute(RUN_ID_ATTR), runId);
        }
    }

    @Override
    public boolean isReady(Dao dao, YPath path) {
        return skipReadyTasks && runId != null && getRunId(dao, path).equals(Option.of(runId));
    }

    private Option<String> getRunId(Dao dao, YPath path) {
        YPath attributePath = path.attribute(RUN_ID_ATTR);
        if (dao.yt().cypress().exists(attributePath)) {
            YTreeNode attr = dao.yt().cypress().get(attributePath);
            return Option.of(attr.stringValue());
        } else {
            return Option.empty();
        }
    }
}
