package ru.yandex.crypta.graph2.matching.human.workflow.component.ops;

import java.util.List;

import com.google.protobuf.InvalidProtocolBufferException;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.local.LocalModeYt;
import ru.yandex.crypta.graph2.dao.yt.local.LocalYield;
import ru.yandex.crypta.graph2.matching.human.config.HumanMatchingConfig;
import ru.yandex.crypta.graph2.matching.human.config.HumanMatchingStrategyFactory;
import ru.yandex.crypta.graph2.matching.human.strategy.HumanMatchingStrategyProvider;
import ru.yandex.crypta.graph2.model.matching.proto.SplitInfo;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class CalculateComponentInfoReducerLocalRun {

    public static void main(String[] args) throws InvalidProtocolBufferException {


        HumanMatchingConfig config = new HumanMatchingConfig();
        config.componentScoringStrategy = "native_human_histogram";
        config.componentsSimilarityStrategies = List.of("exact_socdem", "region");
        config.cryptaIdDispenser = "puid";
        config.mergeType = "BY_EDGES_CUT";
        config.mergeStrategy = "force_merge";

        config.splitStrategy = "new_split";

        LocalYield<YTreeMapNode> result = run("6577660405921255610", config);
        ListF<YTreeMapNode> outVerticesRecs = result.getRecsByIndex(11);
        System.out.println(outVerticesRecs);

        ListF<YTreeMapNode> splitOkInfo = result.getRecsByIndex(6);
        System.out.println("ok " + splitOkInfo.size());
        for (YTreeMapNode record : splitOkInfo) {
            var offers = record.getBytes("offers");
            SplitInfo.InnerSplitOffers parsedOffers = SplitInfo.InnerSplitOffers.parseFrom(offers);
            System.out.println(parsedOffers);
        }
    }

    public static LocalYield<YTreeMapNode> run(String cryptaId, HumanMatchingConfig config) {
        Yt yt = YtConfig.getYt();
        LocalModeYt localModeYt = new LocalModeYt(yt);

        YPath workdir = YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir");
        YPath componentDir = workdir.child("component");
        YPath vertices = componentDir.child("vertices_tmp");
        YPath vp = componentDir.child("vertices_properties_tmp");
        YPath edges = componentDir.child("edges_tmp");
        YPath offers = componentDir.child("unmerged_offers_tmp");
        YPath edgesBetween = workdir.child("merge_apply").child("edges_between_unmerged");

        ListF<YPath> rangedTables = Cf.list(vertices, vp, edges, offers, edgesBetween)
                .map(t -> YtCypressHelper.mkRangeByKey(t, cryptaId));
        HumanMatchingStrategyFactory factory = new HumanMatchingStrategyFactory();
        HumanMatchingStrategyProvider strategyProvider = factory.parseMatchingStrategy(config);

        CalculateComponentInfoReducer reducer = new CalculateComponentInfoReducer(
                strategyProvider.getEdgeInfoProvider(),
                strategyProvider.getComponentScoringStrategy(),
                strategyProvider.getCryptaIdDispenser(),
                strategyProvider.getSplitAlgorithm()
        );

        return localModeYt.reduce(reducer, rangedTables);
    }

}
