package ru.yandex.crypta.graph2.matching.human.workflow.component.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntityReducerWithKey;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeBetweenComponents;
import ru.yandex.crypta.graph2.model.matching.edge.EdgeBetweenWithNewCryptaIds;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyWithNewCryptaIds;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class JoinNewCryptaIdsWithEdgeBetweenComponentsReducer extends YsonMultiEntityReducerWithKey<Edge> {

    @Override
    public Edge key(YTreeMapNode entry) {
        return parse(entry, Edge.class);
    }

    @Override
    public void reduce(Edge edge, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield,
            Statistics statistics) {
        ListF<EdgeBetweenWithNewCryptaIds> edges = parse(entries, EdgeBetweenWithNewCryptaIds.class).toList();
        EdgeBetweenWithNewCryptaIds mainEdge = edges.first();
        MergeKeyWithNewCryptaIds mainMergeKey = mainEdge.getMergeKey();
        mainMergeKey.updateWithOtherMergeKeys(
                edges.map(EdgeBetweenWithNewCryptaIds::getMergeKey)
        );
        MergeKey newMergeKey = MergeKey.betweenComponents(mainMergeKey.getNewLeftCryptaId(), mainMergeKey.getNewRightCryptaId());
        EdgeBetweenComponents out = new EdgeBetweenComponents(
                mainEdge.getEdge(), newMergeKey, mainMergeKey.getNewLeftCryptaId(), mainMergeKey.getNewRightCryptaId());
        if (mainEdge.isOpposite()) {
            out.setLeftCryptaId(mainMergeKey.getNewRightCryptaId());
            out.setRightCryptaId(mainMergeKey.getNewLeftCryptaId());
        }
        yield.yield(serialize(out));
    }
}
