package ru.yandex.crypta.graph2.matching.human.workflow.component.ops.indevice;

import ru.yandex.crypta.graph2.dao.yt.schema.extractor.CustomColumnType;
import ru.yandex.crypta.graph2.model.soup.props.UaProfile.UserAgentEquality;
import ru.yandex.crypta.graph2.model.soup.vertex.ProtobufEnumIdTypeSerializer;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeSerializerClass;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YTreeObject
public class IndeviceLink {

    public static final String INDEVICE_MATCH_TYPE = "indevice";
    public static final String HEURISTIC_MATCH_TYPE = "heuristic";

    @YTreeField
    @YTreeFlattenField
    @SuppressWarnings("UnusedVariable")
    private Vertex deviceId;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private String deviceIdUaProfile = "";

    @YTreeField
    private String targetId;

    @YTreeField
    @YTreeSerializerClass(ProtobufEnumIdTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    @SuppressWarnings("UnusedVariable")
    private EIdType targetIdType;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private String targetIdUaProfile = "";

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private UserAgentEquality uaMatch;

    @YTreeField
    private String matchType;

    public IndeviceLink(Vertex deviceId, Vertex targetVertex, UserAgentEquality uaMatch, String matchType) {
        this.deviceId = deviceId;
        this.targetId = targetVertex.getId();
        this.targetIdType = targetVertex.getIdType();
        this.uaMatch = uaMatch;
        this.matchType = matchType;
    }

    public void setDeviceIdUaProfile(String deviceIdUaProfile) {
        this.deviceIdUaProfile = deviceIdUaProfile;
    }

    public void setTargetIdUaProfile(String targetIdUaProfile) {
        this.targetIdUaProfile = targetIdUaProfile;
    }

    public String getMatchType() {
        return matchType;
    }

    public Vertex getTargetVertex() {
        return new Vertex(targetId, targetIdType);
    }

}
