package ru.yandex.crypta.graph2.matching.human.workflow.init.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph2.dao.yt.proto.NativeProtobufOneOfMessageEntryType;
import ru.yandex.crypta.graph2.matching.human.proto.InitEdgesCryptaIdsAndMergeNeighboursOutRec;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyType;
import ru.yandex.crypta.graph2.model.matching.proto.CryptaIdEdgeMessage;
import ru.yandex.crypta.graph2.model.matching.proto.EdgeBetweenComponents;
import ru.yandex.crypta.graph2.model.matching.proto.EdgeInComponent;
import ru.yandex.crypta.graph2.model.matching.proto.EdgeProtoHelper;
import ru.yandex.crypta.graph2.model.matching.proto.MergeNeighbour;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.proto.Edge;
import ru.yandex.crypta.graph2.model.soup.proto.MultiEdgeKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.types.NativeProtobufEntryType;
import ru.yandex.misc.lang.Check;

import static ru.yandex.crypta.graph2.model.matching.proto.EdgeProtoHelper.edgeBetweenComponentsBuilder;
import static ru.yandex.crypta.graph2.model.matching.proto.EdgeProtoHelper.edgeInComponentBuilder;
import static ru.yandex.crypta.graph2.model.matching.proto.EdgeProtoHelper.toMultiEdgeKey;

public class InitEdgesCryptaIdsAndMergeNeighbours implements
        ReducerWithKey<CryptaIdEdgeMessage, InitEdgesCryptaIdsAndMergeNeighboursOutRec, MultiEdgeKey>,
        YtSerializable {

    public static final ListF<String> MULTI_EDGE_UNIQUE_KEY = Cf.list("id1Type", "id2Type", "id1", "id2");

    private EdgeInfoProvider edgeInfoProvider;
    private MergeKeyType mergeType;

    public InitEdgesCryptaIdsAndMergeNeighbours(EdgeInfoProvider edgeInfoProvider, MergeKeyType mergeType) {
        this.edgeInfoProvider = edgeInfoProvider;
        this.mergeType = mergeType;
    }

    @Override
    public MultiEdgeKey key(CryptaIdEdgeMessage entry) {
        return toMultiEdgeKey(entry);
    }

    @Override
    public void reduce(MultiEdgeKey multiEdgeKey, IteratorF<CryptaIdEdgeMessage> entries,
                       Yield<InitEdgesCryptaIdsAndMergeNeighboursOutRec> yield, Statistics statistics) {
        ListF<CryptaIdEdgeMessage> messages = entries.toList();
        CollectionF<Edge> edges = messages.map(EdgeProtoHelper::toEdge).unique();

        // edge is part of overlimit start from left or right side
        // otherwise both edge messages from edge vertices would be available
        boolean partOfOverlimitStar = !hasDirectAndReverse(messages);

        ListF<String> cryptaIdsOfEdge = messages
                .map(CryptaIdEdgeMessage::getCryptaId)
                .unique().sorted();

        if (partOfOverlimitStar) {
            for (Edge edge : edges) {
                yield.yield(InitEdgesCryptaIdsAndMergeNeighboursOutRec.newBuilder()
                        .setOomRec4(edge).build()
                );
            }

        } else {
            if (cryptaIdsOfEdge.size() == 1) {  // edge belong to single component
                String singleCryptaId = cryptaIdsOfEdge.first();
                for (Edge edge : edges) {
                    EdgeInComponent edgeInComponent = edgeInComponentBuilder(edge).setCryptaId(singleCryptaId).build();
                    yield.yield(InitEdgesCryptaIdsAndMergeNeighboursOutRec.newBuilder()
                            .setEdgeInComponentRec1(edgeInComponent).build()
                    );
                }
            } else {
                Check.equals(2, cryptaIdsOfEdge.size(), "Too much components");
                String leftCryptaId = cryptaIdsOfEdge.get(0);
                String rightCryptaId = cryptaIdsOfEdge.get(1);

                ListF<MergeKey> mergeKeys = getMergeKeys(multiEdgeKey, cryptaIdsOfEdge);

                TEdgeProps.EEdgeStrength linkStrength = edgeInfoProvider.getMaxProtoEdgeTypeStrength(edges);

                for (MergeKey mergeKey : mergeKeys) {
                    // connects several components
                    for (Edge edge : edges) {
                        EdgeBetweenComponents edgeBetweenComponents = edgeBetweenComponentsBuilder(edge)
                                .setLeftCryptaId(leftCryptaId)
                                .setRightCryptaId(rightCryptaId)
                                .setMergeKey(mergeKey.getMergeKey())
                                .setMergeKeyType(mergeKey.getMergeKeyType().name())
                                .build();

                        yield.yield(InitEdgesCryptaIdsAndMergeNeighboursOutRec.newBuilder()
                                .setEdgeBetweenComponentsRec2(edgeBetweenComponents).build()
                        );
                    }

                    for (String cryptaId : cryptaIdsOfEdge) {
                        MergeNeighbour mergeNeighbour = MergeNeighbour.newBuilder().setCryptaId(cryptaId)
                                .setMergeKey(mergeKey.getMergeKey())
                                .setMergeKeyType(mergeKey.getMergeKeyType().name())
                                .setMergeStrength(linkStrength.name())
                                .build();


                        yield.yield(InitEdgesCryptaIdsAndMergeNeighboursOutRec.newBuilder()
                                .setMergeNeighbourRec3(mergeNeighbour).build()
                        );
                    }
                }

            }
        }

    }

    private ListF<MergeKey> getMergeKeys(MultiEdgeKey multiEdgeKey, ListF<String> cryptaIdsOfEdge) {
        if (mergeType.equals(MergeKeyType.BY_COMPONENT)) {
            return cryptaIdsOfEdge.map(MergeKey::fromComponent);
        } else if (mergeType.equals(MergeKeyType.BY_EDGE)) {
            return Cf.list(MergeKey.fromEdge(multiEdgeKey));
        } else if (mergeType.equals(MergeKeyType.BY_EDGES_CUT)) {
//            Check.equals(2, cryptaIdsOfEdge.size());
            String leftCryptaId = cryptaIdsOfEdge.get(0);
            String rightCryptaId = cryptaIdsOfEdge.get(1);
            return Cf.list(MergeKey.betweenComponents(leftCryptaId, rightCryptaId));
        } else {
            throw new IllegalArgumentException("Merge type is not supported: " + mergeType);
        }
    }

    private boolean hasDirectAndReverse(CollectionF<CryptaIdEdgeMessage> messages) {
        boolean hasDirect = false;
        boolean hasReversed = false;
        for (CryptaIdEdgeMessage message : messages) {
            if (message.getReversed()) {
                hasReversed = true;
            } else {
                hasDirect = true;
            }
        }

        return hasDirect && hasReversed;
    }

    @Override
    public YTableEntryType<CryptaIdEdgeMessage> inputType() {
        return new NativeProtobufEntryType<>(
                CryptaIdEdgeMessage.newBuilder()
        );
    }

    @Override
    public YTableEntryType<InitEdgesCryptaIdsAndMergeNeighboursOutRec> outputType() {

        return new NativeProtobufOneOfMessageEntryType<>(
                InitEdgesCryptaIdsAndMergeNeighboursOutRec.newBuilder(), true
        );
    }
}
