package ru.yandex.crypta.graph2.matching.human.workflow.merge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.matching.human.strategy.HumanMatchingStrategyProvider;
import ru.yandex.crypta.graph2.matching.human.workflow.HumanMatchingTask;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.ChooseMergeOrderReducer;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.ConfirmMergeOrderReducer;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.workflow.IterableTables;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class MergeConsensusTask extends HumanMatchingTask<YPath, MergeConsensusTask.MergeConsensusTables> {

    private static final Logger LOG = LoggerFactory.getLogger(MergeConsensusTask.class);

    private YPath mergeOffersOrder;
    private YPath mergeDecisionsConfirmed;
    private YPath mergeOffersOk;
    private YPath mergeOffersFailed;


    public MergeConsensusTask(Dao dao, YPath workdir, HumanMatchingStrategyProvider matchingStrategy, String nameSuffix) {
        super(dao, workdir, matchingStrategy, nameSuffix);

        mergeOffersOrder = workdir.child("merge_offers_order");
        mergeDecisionsConfirmed = workdir.child("merge_decisions_confirmed");
        mergeOffersOk = workdir.child("merge_offers_confirmed");
        mergeOffersFailed = workdir.child("merge_offers_not_confirmed");
    }

    @Override
    protected void runImpl(YPath mergeOffers) {
        dao.ytCypress().ensureDir(workdir);

        LOG.info("Making merge decisions");

        dao.ytCypress().createTableWithSchema(mergeOffersOrder, MergeOffer.class);
        dao.ytCypress().createTableWithSchema(mergeDecisionsConfirmed, MergeOffer.class);

        dao.ytOps().sortSync(mergeOffers, ComponentCenter.CRYPTA_ID_KEY);
        dao.ytOps().reduceSync(
                Cf.list(mergeOffers),
                Cf.list(mergeOffersOrder),
                ComponentCenter.CRYPTA_ID_KEY,
                new ChooseMergeOrderReducer(params.getMergePriority())
        );

        dao.ytOps().sortSync(mergeOffersOrder, ComponentCenter.CRYPTA_ID_KEY);
        dao.ytOps().reduceSync(
                Cf.list(mergeOffersOrder),
                Cf.list(mergeDecisionsConfirmed, mergeOffersOk, mergeOffersFailed),
                ComponentCenter.CRYPTA_ID_KEY,
                new ConfirmMergeOrderReducer(params.getMergePriority())
        );

    }

    @Override
    public MergeConsensusTables getOutput() {
        return new MergeConsensusTables(mergeDecisionsConfirmed, new MergeOffersTables(mergeOffersOk, mergeOffersFailed));
    }

    @Override
    public String getDescription() {
        return "Check mutual agreement of merging components";
    }

    public static class MergeConsensusTables extends IterableTables {
        public YPath mergeDecisionsConfirmed;
        public MergeOffersTables mergeOffersTables;

        public MergeConsensusTables(YPath mergeDecisionsConfirmed, MergeOffersTables mergeOffersTables) {
            this.mergeDecisionsConfirmed = mergeDecisionsConfirmed;
            this.mergeOffersTables = mergeOffersTables;
        }
        @Override
        public ListF<YPath> allTables() {
            return Cf.list(mergeDecisionsConfirmed).plus(mergeOffersTables.allTables());
        }
    }
}
