package ru.yandex.crypta.graph2.matching.human.workflow.merge;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yt.ops.ReduceOperation;
import ru.yandex.crypta.graph2.matching.human.paths.ComponentTableWithEdgesBetween;
import ru.yandex.crypta.graph2.matching.human.strategy.HumanMatchingStrategyProvider;
import ru.yandex.crypta.graph2.matching.human.workflow.HumanMatchingTask;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.UseMergeStrategyReducer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.inside.yt.kosher.common.DataSize;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class UseMergeStrategyTask extends HumanMatchingTask<ComponentTableWithEdgesBetween, MergeOffersTables> {

    private static final Logger LOG = LoggerFactory.getLogger(UseMergeStrategyTask.class);

    private YPath mergeOffersOk;
    private YPath mergeOffersFailed;
    private YPath componentOom;
    private YPath experimentalMergeOffersOk;
    private YPath experimentalMergeOffersFailed;

    public UseMergeStrategyTask(Dao dao, YPath workdir, HumanMatchingStrategyProvider matchingStrategy,
                                String nameSuffix) {
        super(dao, workdir, matchingStrategy, nameSuffix);

        this.mergeOffersOk = workdir.child("merge_offers_ok");
        this.mergeOffersFailed = workdir.child("merge_offers_failed");
        this.componentOom = workdir.child("oom");
        this.experimentalMergeOffersOk = workdir.child("experimental_merge_offers_ok");
        this.experimentalMergeOffersFailed = workdir.child("experimental_merge_offers_failed");
    }

    @Override
    protected void runImpl(ComponentTableWithEdgesBetween componentTableWithEdgesBetween) {
        dao.ytCypress().ensureDir(workdir);

        LOG.info("Preparing for for MergeComponentsReducer");
        dao.ytOps().sortAllParallel(componentTableWithEdgesBetween.allTables(), MergeKey.REDUCE_KEY);

        dao.ytCypress().createTableWithSchema(mergeOffersOk, MergeOffer.class);
        dao.ytCypress().createTableWithSchema(mergeOffersFailed, MergeOffer.class);
        dao.ytCypress().createTableWithSchema(experimentalMergeOffersOk, MergeOffer.class);
        dao.ytCypress().createTableWithSchema(experimentalMergeOffersFailed, MergeOffer.class);

        LOG.info("Running MergeComponentsReducer");
        UseMergeStrategyReducer reducer = new UseMergeStrategyReducer(
                params.getEdgeInfoProvider(),
                params.getMergeAlgorithm()
        );
        ReduceOperation op = dao.ytOps().reduceOperation(
                componentTableWithEdgesBetween.allTables(),
                Cf.list(mergeOffersOk,
                        mergeOffersFailed,
                        componentOom,
                        workdir.child("strange"),
                        experimentalMergeOffersOk,
                        experimentalMergeOffersFailed
                ),
                MergeKey.REDUCE_KEY,
                reducer
        );

        // input size is too large while processing is fast
        // trying to use less jobs
        op.getReduceSpecBuilder().setDataSizePerJob(DataSize.fromGigaBytes(2));
        op.runSync();

    }

    @Override
    public MergeOffersTables getOutput() {
        return new MergeOffersTables(mergeOffersOk, mergeOffersFailed);
    }

    @Override
    public String getDescription() {
        return "Tries to merge components by merge keys and make merge offers based of merge success";
    }
}
