package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferPriority;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferStatus;
import ru.yandex.inside.yt.kosher.operations.Yield;

public class ChooseMergeOrderReducer extends MergeOrderReducer {


    public ChooseMergeOrderReducer(MergeOfferPriority mergeOfferPriority) {
        super(mergeOfferPriority);
    }

    @Override
    protected void whenUsualComponent(MergeOffer bestDecision, ListF<MergeOffer> offers, Yield<MergeOffer> yield) {

        yield.yield(bestDecision.opposite().withStatus(MergeOfferStatus.DECISION_FOLLOWER));

        // and reject all other offers
        for (MergeOffer offer : offers) {
            if (!offer.equals(bestDecision)) {
                yield.yield(offer.opposite().withStatus(MergeOfferStatus.DECISION_REJECTED));
            }
        }
    }

    @Override
    protected void whenLeaderComponent(ListF<MergeOffer> offers, Yield<MergeOffer> yield) {
        // act as most connected: try to join every neighbour to itself
        for (MergeOffer offer : offers) {
            yield.yield(offer.opposite().withStatus(MergeOfferStatus.DECISION_LEADER));
        }
    }


}
