package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import java.util.stream.Stream;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;


/**
 * This is a hack to speed up merge convergence.
 * It represents how many merge offers some component may apply based on links strengths to neighbour components
 */
public class ComponentMergeProbabilityHeuristic {

    public static int getComponentMergeWeight(Stream<TEdgeProps.EEdgeStrength> mergeLinksStrengths) {
        return mergeLinksStrengths.mapToInt(s -> {
            if (s.equals(TEdgeProps.EEdgeStrength.ARTIFICIAL)) {
                return 10000;
            } else if (s.equals(TEdgeProps.EEdgeStrength.TRUSTED)) {
                return 100;
            } else if (s.equals(TEdgeProps.EEdgeStrength.USUAL)) {
                return 1;
            } else {
                return 0;
            }
        }).sum();
    }

}
