package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferStatus;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.misc.lang.Check;

public class ConfirmMergeDecisionReducer implements ReducerWithKey<MergeOffer, MergeOffer, MergeKey> {

    public static final int FINAL_DECISION_OUT_INDEX = 0;
    public static final int MERGE_OFFER_STATUSES_OK_OUT_INDEX = 1;
    public static final int MERGE_OFFER_STATUSES_FAILED_OUT_INDEX = 2;

    @Override
    public MergeKey key(MergeOffer entry) {
        return entry.getMergeKey();
    }

    @Override
    public void reduce(MergeKey mergeOffer, IteratorF<MergeOffer> entries, Yield<MergeOffer> yield, Statistics statistics) {
        ListF<MergeOffer> mergeOffers = entries.toList();
        MergeOffer leaderOffer = null;
        boolean hasFollowerConfirmation = false;

        Check.isTrue(
                mergeOffers.size() <= 2,
                "More than 2 MergeOffers: ", mergeOffers.mkString("\n")
        );

        for (MergeOffer offer : mergeOffers) {
            if (offer.getStatus().equals(MergeOfferStatus.DECISION_LEADER)) {
                if (leaderOffer == null) {
                    leaderOffer = offer;
                }
            } else if (offer.getStatus().equals(MergeOfferStatus.DECISION_FOLLOWER)) {
                hasFollowerConfirmation = true;
            }
        }

        boolean confirmed = leaderOffer != null && hasFollowerConfirmation;

        if (confirmed) {
            // opposite because fromCryptaId in MergeOffer will be used to apply decision
            yield.yield(FINAL_DECISION_OUT_INDEX, leaderOffer.withStatus(MergeOfferStatus.CONFIRMED));
        }

        for (MergeOffer offer : mergeOffers) {
            if (confirmed) {
                yield.yield(MERGE_OFFER_STATUSES_OK_OUT_INDEX, offer.withStatus(MergeOfferStatus.CONFIRMED));
            } else {
                yield.yield(MERGE_OFFER_STATUSES_FAILED_OUT_INDEX, offer.withStatus(MergeOfferStatus.NOT_CONFIRMED));
            }
        }
    }
}
