package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferPriority;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferStatus;
import ru.yandex.crypta.graph2.utils.IteratorUtils;
import ru.yandex.crypta.graph2.utils.IteratorUtils.IteratorSplit;
import ru.yandex.inside.yt.kosher.operations.Yield;

public class ConfirmMergeOrderReducer extends MergeOrderReducer {

    public static final int FINAL_DECISION_OUT_INDEX = 0;
    public static final int MERGE_OFFERS_OK_OUT_INDEX = 1;
    public static final int MERGE_OFFERS_FAILED_OUT_INDEX = 2;

    public ConfirmMergeOrderReducer(MergeOfferPriority mergeOfferPriority) {
        super(mergeOfferPriority);
    }

    @Override
    protected void whenUsualComponent(MergeOffer bestConfirmation, ListF<MergeOffer> offers, Yield<MergeOffer> yield) {

        if (MergeOfferStatus.DECISION_LEADER.equals(bestConfirmation.getStatus())) {
            // opposite component decided to be a leader
            // thus the direction of merge is chosen
            // and leader must decide whether to confirm offer or not

        } else if (MergeOfferStatus.DECISION_FOLLOWER.equals(bestConfirmation.getStatus())) {
            // opposite component decided to be a follower
            // it guaranteed to chose only this decision and rejected others
            // thus we only need to decide on merge direction. Opposite will decide the same

            if (bestConfirmation.getToCryptaId().compareTo(bestConfirmation.getFromCryptaId()) > 0) {
                yield.yield(FINAL_DECISION_OUT_INDEX, bestConfirmation.withStatus(MergeOfferStatus.CONFIRMED));
            }

            yield.yield(MERGE_OFFERS_OK_OUT_INDEX, bestConfirmation.withStatus(MergeOfferStatus.CONFIRMED));

        } else {
            yield.yield(MERGE_OFFERS_FAILED_OUT_INDEX, bestConfirmation.withStatus(MergeOfferStatus.NOT_CONFIRMED));
        }

        // also need to report all others rejected follower offers from previous step
        for (MergeOffer offer : offers) {
            if (!offer.equals(bestConfirmation)) {
                yield.yield(MERGE_OFFERS_FAILED_OUT_INDEX,
                        offer.withStatus(MergeOfferStatus.NOT_CONFIRMED)
                );
            }
        }
    }

    @Override
    protected void whenLeaderComponent(ListF<MergeOffer> offers, Yield<MergeOffer> yield) {
        ListF<MergeOffer> leaderOffers = offers.filter(o -> o.getStatus().equals(MergeOfferStatus.DECISION_LEADER));

        if (leaderOffers.isNotEmpty()) {
            // the only known case is equal triangle (look at tests)
            offers = offers.filter(o -> !o.getStatus().equals(MergeOfferStatus.DECISION_LEADER));
        }

        // confirm only followers offers till the first rejected
        IteratorSplit<MergeOffer> split = IteratorUtils.takeWhile(
                mergeOfferPriority.sortMergeOfferByActivityDesc(offers),
                o -> !o.getStatus().equals(MergeOfferStatus.DECISION_REJECTED)
        );

        for (MergeOffer offer : split.getHead()) {
            MergeOffer mergeDecision = offer.opposite().withStatus(MergeOfferStatus.CONFIRMED);
            yield.yield(FINAL_DECISION_OUT_INDEX, mergeDecision);

            // report for both leader and follower
            yield.yield(MERGE_OFFERS_OK_OUT_INDEX, mergeDecision);
            yield.yield(MERGE_OFFERS_OK_OUT_INDEX, offer.withStatus(MergeOfferStatus.CONFIRMED));
        }

        split.getTail().forEachRemaining(offer -> {

                    if (!offer.getStatus().equals(MergeOfferStatus.DECISION_REJECTED)) {
                        // if rejected by this leader, must report for both leader and follower
                        yield.yield(MERGE_OFFERS_FAILED_OUT_INDEX,
                                offer.opposite().withStatus(MergeOfferStatus.NOT_CONFIRMED)
                        );
                    }

                    // report for both leader and follower
                    yield.yield(MERGE_OFFERS_FAILED_OUT_INDEX,
                            offer.withStatus(MergeOfferStatus.NOT_CONFIRMED)
                    );

                }

        );

        for (MergeOffer leaderOffer : leaderOffers) {
            // each leader report for itself
            yield.yield(MERGE_OFFERS_FAILED_OUT_INDEX,
                    leaderOffer.withStatus(MergeOfferStatus.NOT_CONFIRMED)
            );
        }

    }


}
