package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.local.LocalModeYt;
import ru.yandex.crypta.graph2.dao.yt.local.LocalYield;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferPriority;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ConfirmMergeOrderReducerLocalRun {


    public static void main(String[] args) {

        LocalYield<MergeOffer> result = run("9700616999238609448");
        ListF<MergeOffer> outOffers = result.getRecsByIndex(0);
        for (var offer : outOffers) {
            System.out.println(offer);
        }

    }

    public static LocalYield<MergeOffer> run(String cc) {
        Yt yt = YtConfig.getYt();
        LocalModeYt localModeYt = new LocalModeYt(yt);


        YPath mergeOffersOrder = YPath.simple(
                "//home/crypta/production/state/graph/v2/matching/workdir/merge/merge_offers_order"
        );

        MergeOrderReducer reducer = new ChooseMergeOrderReducer(new MergeOfferPriority(true));

        return localModeYt.reduce(reducer, YtCypressHelper.mkRangeByKey(
                mergeOffersOrder,
                cc
        ));
    }
}
