package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferPriority;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;

abstract class MergeOrderReducer implements ReducerWithKey<MergeOffer, MergeOffer, String>, YtSerializable {

    protected MergeOfferPriority mergeOfferPriority;

    protected MergeOrderReducer(MergeOfferPriority mergeOfferPriority) {
        this.mergeOfferPriority = mergeOfferPriority;
    }

    @Override
    public String key(MergeOffer entry) {
        return entry.getFromCryptaId();
    }

    @Override
    public void reduce(String componentCenter, IteratorF<MergeOffer> entries, Yield<MergeOffer> yield,
                       Statistics statistics) {
        ListF<MergeOffer> offers = entries.toList();

        // trying to merge every crypta id to the most connected neighbour to speed up matching
        if (mergeOfferPriority.hasBetterLeaderCandidates(offers)) {
            // join to the best more connected
            MergeOffer bestDecision = mergeOfferPriority.getBest(offers);

            whenUsualComponent(bestDecision, offers, yield);

        } else {
            whenLeaderComponent(offers, yield);
        }

    }

    /**
     * Usual component must choose single join
     */
    protected abstract void whenUsualComponent(MergeOffer bestDecision, ListF<MergeOffer> offers,
                                               Yield<MergeOffer> yield);

    /**
     * Optimized component is allowed to participate in multiple joins, but to make sure these joins are directed TO
     * itself
     */
    protected abstract void whenLeaderComponent(ListF<MergeOffer> offers, Yield<MergeOffer> yield);

}
