package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonCachedSerializerSupport;
import ru.yandex.crypta.graph2.dao.yt.proto.NativeProtobufOneOfMessageEntryType;
import ru.yandex.crypta.graph2.matching.human.proto.UseMergeStrategyReducerInRec;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.MergeOffers;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.TryMergeByEdgesCut;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.helper.GraphInfoRecsParserNew;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class UseMergeStrategyReducer extends YsonCachedSerializerSupport implements ReducerWithKey<UseMergeStrategyReducerInRec, YTreeMapNode, MergeKey>, YtSerializable {

    public static final int MERGE_OFFER_OUT_INDEX = 0;
    public static final int FAILED_OUT_INDEX = 1;
    private TryMergeByEdgesCut merger;

    public UseMergeStrategyReducer(EdgeInfoProvider edgeInfoProvider, MergeAlgorithm mergeAlgorithm) {
        this.merger = new TryMergeByEdgesCut(mergeAlgorithm);
    }

    @Override
    public MergeKey key(UseMergeStrategyReducerInRec entry) {
        if (entry.hasComponentToMergeRec1()) {
            var table = entry.getComponentToMergeRec1();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else if (entry.hasEdgeBetweenComponentsRec2()) {
            var table = entry.getEdgeBetweenComponentsRec2();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else {
            throw new IllegalArgumentException("Rec type is not supported " + entry);
        }
    }

    @Override
    public void reduce(MergeKey mergeKey, IteratorF<UseMergeStrategyReducerInRec> entries, Yield<YTreeMapNode> yield, Statistics statistics) {

        GraphInfoRecsParserNew parser = new GraphInfoRecsParserNew();
        GraphInfo graphInfo = parser.parseInput(entries);
        MergeOffers mergeOffers = merger.suggestMergeOffers(mergeKey, graphInfo, graphInfo.edgesBetweenComponents);

        for (MergeOffer mergeOffer : mergeOffers.getOkOffers()) {
            yield.yield(MERGE_OFFER_OUT_INDEX, serialize(mergeOffer));
            yield.yield(MERGE_OFFER_OUT_INDEX, serialize(mergeOffer.opposite()));
        }

        for (MergeOffer mergeOffer : mergeOffers.getFailedOffers()) {
            yield.yield(FAILED_OUT_INDEX, serialize(mergeOffer));
            yield.yield(FAILED_OUT_INDEX, serialize(mergeOffer.opposite()));
        }

    }

    @Override
    public YTableEntryType<UseMergeStrategyReducerInRec> inputType() {
        return new NativeProtobufOneOfMessageEntryType<>(
                UseMergeStrategyReducerInRec.newBuilder(), true
        );
    }
}
