package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonCachedSerializerSupport;
import ru.yandex.crypta.graph2.dao.yt.proto.NativeProtobufOneOfMessageEntryType;
import ru.yandex.crypta.graph2.matching.human.proto.UseMergeStrategyReducerInRec;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.MergeOffers;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.TryMergeByEdge;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.TryMergeByEdgesCut;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo.TryMergeByVertex;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.helper.GraphInfoProtoRecsParser;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKeyType;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class UseMergeStrategyReducerWithProtoInput extends YsonCachedSerializerSupport implements ReducerWithKey<UseMergeStrategyReducerInRec, YTreeMapNode, MergeKey>, YtSerializable {

    public static final int MERGE_OFFER_OUT_INDEX = 0;
    public static final int FAILED_OUT_INDEX = 1;

    public static final int OOM_OUT_INDEX = 2;
    public static final int STRANGE_OUT_INDEX = 3;

    public static final int MERGE_OFFER_EXPERIMENTAL_OUT_INDEX = 4;
    public static final int FAILED_EXPERIMENTAL_OUT_INDEX = 5;

    private ListF<TryMerges> mergers = Cf.arrayList();;

    public UseMergeStrategyReducerWithProtoInput(EdgeInfoProvider edgeInfoProvider, MergeAlgorithm mergeAlgorithm) {
        this.mergers.add(
                new TryMerges(
                        new TryMergeByVertex(edgeInfoProvider, mergeAlgorithm),
                        new TryMergeByEdge(mergeAlgorithm),
                        new TryMergeByEdgesCut(mergeAlgorithm),
                        MERGE_OFFER_OUT_INDEX,
                        FAILED_OUT_INDEX
                )
        );
    }

    public UseMergeStrategyReducerWithProtoInput(EdgeInfoProvider edgeInfoProvider, MergeAlgorithm mergeAlgorithm, MergeAlgorithm experimentalMergeAlgorithm) {
        this(edgeInfoProvider, mergeAlgorithm);
        this.mergers.add(
                new TryMerges(
                        new TryMergeByVertex(edgeInfoProvider, experimentalMergeAlgorithm),
                        new TryMergeByEdge(experimentalMergeAlgorithm),
                        new TryMergeByEdgesCut(experimentalMergeAlgorithm),
                        MERGE_OFFER_EXPERIMENTAL_OUT_INDEX,
                        FAILED_EXPERIMENTAL_OUT_INDEX
                )
        );
    }

    @Override
    public MergeKey key(UseMergeStrategyReducerInRec entry) {
        if (entry.hasComponentToMergeRec1()) {
            var table = entry.getComponentToMergeRec1();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else if (entry.hasEdgeBetweenComponentsRec2()) {
            var table = entry.getEdgeBetweenComponentsRec2();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else {
            throw new IllegalArgumentException("Rec type is not supported " + entry);
        }
    }

    static class TryMerges implements YtSerializable {
        final TryMergeByVertex byVertexDelegate;
        final TryMergeByEdge byEdgeDelegate;
        final TryMergeByEdgesCut byEdgesCutDelegate;
        final int okOutIndex;
        final int failedOutIndex;

        public TryMerges(
                TryMergeByVertex byVertexDelegate, TryMergeByEdge byEdgeDelegate, TryMergeByEdgesCut byEdgesCutDelegate,
                int okOutIndex, int failedOutIndex) {
            this.byVertexDelegate = byVertexDelegate;
            this.byEdgeDelegate = byEdgeDelegate;
            this.byEdgesCutDelegate = byEdgesCutDelegate;
            this.okOutIndex = okOutIndex;
            this.failedOutIndex = failedOutIndex;
        }
    }

    private MergeOffers tryMerge(MergeKey mergeKey, GraphInfo graphInfo, TryMerges merger) {
        if (mergeKey.getMergeKeyType() == MergeKeyType.BY_VERTEX) {

            Option<Vertex> joiningVertex = graphInfo.vertexToComponents.keySet().find(
                    v -> MergeKey.fromVertex(v).equals(mergeKey)
            );
            if (joiningVertex.isPresent()) {
                return merger.byVertexDelegate.suggestMergeOffers(mergeKey, graphInfo, joiningVertex.get());
            }

        } else if (mergeKey.getMergeKeyType() == MergeKeyType.BY_EDGE) {

            if (graphInfo.edgesBetweenComponents.isNotEmpty()) {
                return merger.byEdgeDelegate.suggestMergeOffers(mergeKey, graphInfo, graphInfo.edgesBetweenComponents);
            }
        } else if (mergeKey.getMergeKeyType() == MergeKeyType.BY_EDGES_CUT) {
            return merger.byEdgesCutDelegate.suggestMergeOffers(mergeKey, graphInfo, graphInfo.edgesBetweenComponents);
        } else {
            throw new UnsupportedOperationException("Merge type is not supported: " + mergeKey);
        }

        return new MergeOffers();
    }

    @Override
    public void reduce(MergeKey mergeKey, IteratorF<UseMergeStrategyReducerInRec> entries, Yield<YTreeMapNode> yield, Statistics statistics) {

        GraphInfoProtoRecsParser parser = new GraphInfoProtoRecsParser();
        GraphInfo graphInfo = parser.parseInput(entries);

        for (TryMerges merger : this.mergers) {
            MergeOffers mergeOffers = tryMerge(mergeKey, graphInfo, merger);

            for (MergeOffer mergeOffer : mergeOffers.getOkOffers()) {
                yield.yield(merger.okOutIndex, serialize(mergeOffer));
                yield.yield(merger.okOutIndex, serialize(mergeOffer.opposite()));
            }

            for (MergeOffer mergeOffer : mergeOffers.getFailedOffers()) {
                yield.yield(merger.failedOutIndex, serialize(mergeOffer));
                yield.yield(merger.failedOutIndex, serialize(mergeOffer.opposite()));
            }
        }
    }

    @Override
    public YTableEntryType<UseMergeStrategyReducerInRec> inputType() {
        return new NativeProtobufOneOfMessageEntryType<>(
                UseMergeStrategyReducerInRec.newBuilder(), true
        );
    }
}
