package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.local.LocalModeYt;
import ru.yandex.crypta.graph2.dao.yt.local.LocalYield;
import ru.yandex.crypta.graph2.matching.human.proto.UseMergeStrategyReducerInRec;
import ru.yandex.crypta.graph2.model.matching.component.score.HumanMultiHistogramScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.component.similarity.ComponentsExactSocdemSimilarityStrategy;
import ru.yandex.crypta.graph2.model.matching.component.similarity.ComponentsRegionSimilarityStrategy;
import ru.yandex.crypta.graph2.model.matching.component.similarity.ComponentsSimilarityMultiStrategy;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeByScoreAndSimilarityAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.weight.DefaultEdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class UseMergeStrategyReducerWithProtoInputLocalRun {

    public static void main(String[] args) {

        String mergeKey = "12707277423503933443_15358697887116349039";

        LocalYield<YTreeMapNode> result = run(mergeKey);
        ListF<YTreeMapNode> outVerticesRecs = result.getRecsByIndex(0);
        System.out.println(outVerticesRecs);

        System.out.println(result.getRecsByIndex(1));
        System.out.println(result.getRecsByIndex(4));
        System.out.println(result.getRecsByIndex(5));
    }

    public static LocalYield<YTreeMapNode> run(String mergeKey) {
        Yt yt = YtConfig.getYt();
        LocalModeYt localModeYt = new LocalModeYt(yt);

        YPath componentsByMergeKey =
                YPath.simple("//home/crypta/production/state/graph/v2exp/matching/workdir/prepare/components_by_merge_key");
        YPath soupEdgesBetweenComponentsByMergeKey = YPath.simple(
                "//home/crypta/production/state/graph/v2exp/matching/workdir/init/soup_edges_between_components_by_merge_key");

        EdgeInfoProvider edgeInfoProvider = new DefaultEdgeInfoProvider();

        ListF<YPath> rangedTables =
                Cf.list(componentsByMergeKey, soupEdgesBetweenComponentsByMergeKey).map(t -> YtCypressHelper.mkRangeByKey(t, mergeKey));

        MergeByScoreAndSimilarityAlgorithm.MergeMode mergeMode = new MergeByScoreAndSimilarityAlgorithm.MergeMode();
        mergeMode.ignoreScoresForGoodLinks = true;
        MergeAlgorithm mergeAlgorithm = new MergeByScoreAndSimilarityAlgorithm(
                new HumanMultiHistogramScoringStrategy(false, Option.of(7.5)),
                new ComponentsSimilarityMultiStrategy(Cf.list(
                        new ComponentsRegionSimilarityStrategy(),
                        new ComponentsExactSocdemSimilarityStrategy()
                )),
                edgeInfoProvider,
                mergeMode
        );

        UseMergeStrategyReducer reducer = new UseMergeStrategyReducer(
                edgeInfoProvider,
                mergeAlgorithm
        );

        return localModeYt.reduce(
                reducer,
                rangedTables,
                UseMergeStrategyReducerInRec.newBuilder()
        );

    }
}
