package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yql.Yql;
import ru.yandex.crypta.graph2.dao.yql.YqlConfig;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.ops.ReduceOperation;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.crypta.graph2.matching.human.config.HumanMatchingConfig;
import ru.yandex.crypta.graph2.matching.human.config.HumanMatchingStrategyFactory;
import ru.yandex.crypta.graph2.matching.human.strategy.HumanMatchingStrategyProvider;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.utils.NativeLibHelper;
import ru.yandex.crypta.graph2.utils.YamlConfig;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.DataSize;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class UseMergeStrategyReducerWithProtoInputTestRun {
    public static void main(String[] args) {

        NativeLibHelper.setLocalJavaLibraryPath();
        HumanMatchingConfig config = YamlConfig.readConfigFromFile(
                "/Users/artembelov/dev/arcadia/crypta/graph/matching/human/config-prod.yaml",
                HumanMatchingConfig.class
        );

        Yt yt = YtConfig.getYt(true);
        Yql yql = YqlConfig.getYql();

        Dao dao = new Dao(yt, yql, new YtOpsParams());

        HumanMatchingStrategyProvider matchingStrategyProvider =
                new HumanMatchingStrategyFactory().parseMatchingStrategy(config);

        UseMergeStrategyReducerWithProtoInput reducer = new UseMergeStrategyReducerWithProtoInput(
                matchingStrategyProvider.getEdgeInfoProvider(),
                matchingStrategyProvider.getMergeAlgorithm()
        );


        YPath out = YPath.simple("//home/crypta/team/artembelov/matching/workdir/merge_proto_test");
        dao.yt().cypress().create(out, CypressNodeType.MAP, true, true);

        ReduceOperation op = dao.ytOps().reduceOperation(
                Cf.list(
                        YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/prepare/components_by_merge_key"),
                        YPath.simple("//home/crypta/production/state/graph/v2/matching/workdir/init/soup_edges_between_components_by_merge_key")
                ),
                Cf.list(out.child("merge_offers_of"),
                        out.child("merge_offers_failed"),
                        out.child("oom"),
                        out.child("strange")),
                MergeKey.REDUCE_KEY,
                reducer
        );
        op.getReduceSpecBuilder().setDataSizePerJob(DataSize.fromGigaBytes(2));
        op.runSync();

    }
}
