package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;

public class MergeOffers {

    private ListF<MergeOffer> okOffers;
    private ListF<MergeOffer> failedOffers;

    public MergeOffers(ListF<MergeOffer> okOffers, ListF<MergeOffer> failedOffers) {
        this.okOffers = okOffers;
        this.failedOffers = failedOffers;
    }

    public MergeOffers() {
        this.okOffers = Cf.arrayList();
        this.failedOffers = Cf.arrayList();
    }

    public ListF<MergeOffer> getOkOffers() {
        return okOffers;
    }

    public ListF<MergeOffer> getFailedOffers() {
        return failedOffers;
    }

    public void addOkOffer(MergeOffer offer) {
        this.okOffers.add(offer);
    }

    public void addOFailedOffer(MergeOffer offer) {
        this.failedOffers.add(offer);
    }
}
