package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferStatus;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.MultiEdgeKey;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.misc.lang.Check;

public class TryMergeByEdge implements TryMerge<ListF<Edge>> {

    public static final SetF<MergeOfferStatus> FAIL_INIT = Cf.set(
            MergeOfferStatus.FAILED_BY_SCORE,
            MergeOfferStatus.FAILED_BY_SIMILARITY
    );

    private final MergeAlgorithm mergeStrategy;

    public TryMergeByEdge(MergeAlgorithm mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
    }

    @Override
    public MergeOffers suggestMergeOffers(MergeKey mergeKey, GraphInfo graphInfo, ListF<Edge> joiningEdges) {

        MultiEdgeKey joiningEdgeKey = getMultiEdgeKey(graphInfo.edgesBetweenComponents);

        Vertex leftVertex = joiningEdgeKey.getLeftVertex();
        Option<Component> leftComponents = graphInfo.vertexToComponents.getO(leftVertex);

        Vertex rightVertex = joiningEdgeKey.getRightVertex();
        Option<Component> rightComponents = graphInfo.vertexToComponents.getO(rightVertex);

        MergeOffers mergeOffers = new MergeOffers();

        for (Component leftComponent : leftComponents) {
            for (Component rightComponent : rightComponents) {
                if (leftComponent.getCryptaId().equals(rightComponent.getCryptaId())) {
                    continue;
                }

                MergeOffer mergeOffer = mergeStrategy.merge(mergeKey, leftComponent, rightComponent,
                        graphInfo, joiningEdges);

                if (FAIL_INIT.containsTs(mergeOffer.getStatus())) {
                    mergeOffers.addOFailedOffer(mergeOffer);
                } else {
                    mergeOffers.addOkOffer(mergeOffer);
                }
            }
        }

        return mergeOffers;
    }

    private MultiEdgeKey getMultiEdgeKey(ListF<Edge> edges) {
        SetF<MultiEdgeKey> multiEdgeKey = edges.map(Edge::getMultiEdgeKey).unique();
        Check.hasSize(1, multiEdgeKey, String.valueOf(edges));
        return multiEdgeKey.iterator().next();
    }
}
