package ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.algo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOffer;
import ru.yandex.crypta.graph2.model.matching.merge.algo.merge.MergeAlgorithm;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;

public class TryMergeByEdgesCut implements TryMerge<ListF<Edge>> {


    private final MergeAlgorithm mergeStrategy;

    public TryMergeByEdgesCut(MergeAlgorithm mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
    }

    @Override
    public MergeOffers suggestMergeOffers(MergeKey mergeKey, GraphInfo graphInfo, ListF<Edge> joiningEdges) {
        if (graphInfo.components.keySet().size() != 2) {
            return new MergeOffers();
        }

        ListF<Component> componentsL = graphInfo.components.values().toList();

        MergeOffers mergeOffers = new MergeOffers();

        MergeOffer mergeOffer = mergeStrategy.merge(mergeKey,
                componentsL.get(0),
                componentsL.get(1),
                graphInfo, joiningEdges
        );

        if (TryMergeByEdge.FAIL_INIT.containsTs(mergeOffer.getStatus())) {
            mergeOffers.addOFailedOffer(mergeOffer);
        } else {
            mergeOffers.addOkOffer(mergeOffer);
        }

        return mergeOffers;
    }

}
